/*
 * Decompiled with CFR 0.152.
 */
package biosql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class LargeSequenceTest {
    public static void main(String[] args) throws Exception {
        Feature f;
        if (args.length < 3) {
            System.err.println("usage: LargeSequenceTest <database_url> <username> <password>");
            System.err.println("example: LargeSequenceTest jdbc:postgresql://localhost/thomasd_biosql2 thomas \"\"");
            return;
        }
        String dbURL = args[0];
        String dbUser = args[1];
        String dbPass = args[2];
        String bioName = "testdb2";
        BioSQLSequenceDB seqDB = new BioSQLSequenceDB(dbURL, dbUser, dbPass, bioName, true);
        ArrayList<AtomicSymbol> symbols = new ArrayList<AtomicSymbol>();
        for (int i = 0; i < 50000; ++i) {
            symbols.add(DNATools.a());
            symbols.add(DNATools.c());
            symbols.add(DNATools.g());
            symbols.add(DNATools.t());
        }
        SimpleSymbolList sl = new SimpleSymbolList((Alphabet)DNATools.getDNA(), symbols);
        SimpleSequence seq = new SimpleSequence((SymbolList)sl, null, "testSeq", Annotation.EMPTY_ANNOTATION);
        seqDB.addSequence((Sequence)seq);
        int count = 0;
        seq = seqDB.getSequence("testSeq");
        for (int i = 1; i < 190000; i += 1000) {
            Feature.Template templ = new Feature.Template();
            templ.type = "test";
            templ.source = "test";
            templ.location = new RangeLocation(i, i + 1100);
            templ.annotation = Annotation.EMPTY_ANNOTATION;
            seq.createFeature(templ);
            ++count;
        }
        seq = null;
        seqDB = null;
        seqDB = new BioSQLSequenceDB(dbURL, dbUser, dbPass, bioName, true);
        seq = seqDB.getSequence("testSeq");
        ArrayList<Integer> startList = new ArrayList<Integer>();
        Iterator i = seq.features();
        while (i.hasNext()) {
            f = (Feature)i.next();
            startList.add(new Integer(f.getLocation().getMin()));
            --count;
        }
        Collections.sort(startList);
        i = startList.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        System.out.println("Balance: " + count);
        i = seq.features();
        while (i.hasNext()) {
            f = (Feature)i.next();
        }
        seq = null;
        seqDB = new BioSQLSequenceDB(dbURL, dbUser, dbPass, bioName, true);
        seqDB.removeSequence("testSeq");
    }
}

