/*
 * Decompiled with CFR 0.152.
 */
package biosql;

import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.io.EmblLikeFormat;

public class SeqEMBL {
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage SeqEMBL <url> <user> <password> <database> [id1] [id2] ...");
            return;
        }
        String dbURL = args[0];
        String dbUser = args[1];
        String dbPass = args[2];
        String bioName = args[3];
        BioSQLSequenceDB seqDB = new BioSQLSequenceDB(dbURL, dbUser, dbPass, bioName, false);
        EmblLikeFormat ff = new EmblLikeFormat();
        if (args.length < 5) {
            SequenceIterator si = seqDB.sequenceIterator();
            while (si.hasNext()) {
                ff.writeSequence(si.nextSequence(), System.out);
            }
        } else {
            for (int i = 4; i < args.length; ++i) {
                Sequence seq = seqDB.getSequence(args[i]);
                ff.writeSequence(seq, System.out);
            }
        }
    }
}

