/*
 * Decompiled with CFR 0.152.
 */
package biosql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class UploadFlat {
    public static void main(String[] args) {
        try {
            FiniteAlphabet alpha;
            EmblProcessor.Factory sbFact;
            EmblLikeFormat sFormat;
            if (args.length < 6) {
                throw new Exception("Use: UploadFlat dbURL dbUser dbPass biodatabase format file1 [file2...]");
            }
            String dbURL = args[0];
            String dbUser = args[1];
            String dbPass = args[2];
            String bioDB = args[3];
            String format = args[4];
            System.out.println("Opening database: " + bioDB);
            BioSQLSequenceDB seqDB = new BioSQLSequenceDB(dbURL, dbUser, dbPass, bioDB, true);
            if ("embl".equalsIgnoreCase(format)) {
                sFormat = new EmblLikeFormat();
                sbFact = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
                alpha = DNATools.getDNA();
            } else if ("swissprot".equalsIgnoreCase(format)) {
                sFormat = new EmblLikeFormat();
                sbFact = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
                alpha = ProteinTools.getAlphabet();
            } else if ("fasta".equalsIgnoreCase(format)) {
                sFormat = new FastaFormat();
                sbFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
                alpha = DNATools.getDNA();
            } else if ("fasta-protein".equalsIgnoreCase(format)) {
                sFormat = new FastaFormat();
                sbFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
                alpha = ProteinTools.getAlphabet();
            } else {
                System.err.println("Unknown format: " + format);
                return;
            }
            SymbolTokenization rParser = alpha.getTokenization("token");
            for (int i = 5; i < args.length; ++i) {
                File swissProtFile = new File(args[i]);
                BufferedReader sReader = new BufferedReader(new InputStreamReader(new FileInputStream(swissProtFile)));
                StreamReader seqI = new StreamReader(sReader, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sbFact);
                while (seqI.hasNext()) {
                    try {
                        System.out.print(".");
                        Sequence seq = seqI.nextSequence();
                        seqDB.addSequence(seq);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                    }
                }
            }
            System.out.println();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

