/*
 * Decompiled with CFR 0.152.
 */
package blastxml;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.sax.blastxml.BlastXMLParserFacade;
import org.biojava.bio.program.ssbind.BlastLikeSearchBuilder;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.DummySequenceDB;
import org.biojava.bio.seq.db.DummySequenceDBInstallation;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BlastParser {
    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream(args[0]);
            BlastXMLParserFacade parser = new BlastXMLParserFacade();
            SeqSimilarityAdapter adapter = new SeqSimilarityAdapter();
            parser.setContentHandler((ContentHandler)adapter);
            ArrayList results = new ArrayList();
            BlastLikeSearchBuilder builder = new BlastLikeSearchBuilder(results, (SequenceDB)new DummySequenceDB("queries"), (SequenceDBInstallation)new DummySequenceDBInstallation());
            adapter.setSearchContentHandler((SearchContentHandler)builder);
            parser.parse(new InputSource(is));
            for (SeqSimilaritySearchResult result : results) {
                Annotation anno = result.getAnnotation();
                for (Object key : anno.keys()) {
                    Object property = anno.getProperty(key);
                    System.out.println(key + " : " + property);
                }
                System.out.println("Hits: ");
                for (SeqSimilaritySearchHit hit : result.getHits()) {
                    System.out.print("\tmatch: " + hit.getSubjectID());
                    System.out.println("\te score: " + hit.getEValue());
                }
                System.out.println("\n");
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (BioException be) {
            be.printStackTrace();
        }
    }
}

