/*
 * Decompiled with CFR 0.152.
 */
package das;

import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;

public class TestDAS {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("java das.TestDAS <url>");
        }
        String dbURLString = args[0];
        URL dbURL = new URL(dbURLString);
        DASSequenceDB dasDB = new DASSequenceDB(dbURL);
        System.out.println("Top-level entry points:");
        Set ids = dasDB.ids();
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            System.out.println(i.next().toString());
        }
        DASSequence dasSeq = (DASSequence)dasDB.getSequence((String)ids.iterator().next());
        System.out.println("Length: " + dasSeq.length());
        System.out.println("1st 10 bases: " + dasSeq.subStr(1, 10));
        System.out.println("Feature count: " + dasSeq.countFeatures());
        TestDAS.printFeatures((FeatureHolder)dasSeq, System.out, "");
    }

    public static void printFeatures(FeatureHolder fh, PrintStream pw, String prefix) throws Exception {
        Iterator i = fh.features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            pw.print(prefix);
            pw.print(f.getType());
            pw.print(" at ");
            pw.print(f.getLocation().toString());
            pw.println();
            TestDAS.printFeatures((FeatureHolder)f, pw, prefix + "    ");
        }
    }
}

