/*
 * Decompiled with CFR 0.152.
 */
package das;

import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;

public class TestDASH {
    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            throw new Exception("java das.TestDAS <url> <seq> <min> <max>");
        }
        String dbURLString = args[0];
        String seqName = args[1];
        int min = Integer.parseInt(args[2]);
        int max = Integer.parseInt(args[3]);
        URL dbURL = new URL(dbURLString);
        DASSequenceDB dasDB = new DASSequenceDB(dbURL);
        DASSequence dasSeq = (DASSequence)dasDB.getSequence(seqName);
        System.out.println("Length: " + dasSeq.length());
        System.out.println("1st 10 bases: " + dasSeq.subStr(1, 10));
        TestDASH.printFeatures((FeatureHolder)dasSeq, (FeatureFilter)new FeatureFilter.OverlapsLocation((Location)new RangeLocation(min, max)), System.out, "");
    }

    public static void printFeatures(FeatureHolder fh, FeatureFilter ff, PrintStream pw, String prefix) throws Exception {
        Iterator i = fh.filter(ff, true).features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            pw.print(prefix);
            pw.print(f.getType());
            pw.print(" at ");
            pw.print(f.getLocation().toString());
            try {
                String id = (String)f.getAnnotation().getProperty((Object)"org.biojava.bio.program.das.feature_id");
                pw.print(" (" + id + ')');
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            pw.println();
        }
    }
}

