/*
 * Decompiled with CFR 0.152.
 */
package dist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.gui.DNAStyle;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.gui.TextLogoPainter;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class TestDistribution {
    private static Distribution nullModel;

    public static void main(String[] args) {
        try {
            FiniteAlphabet dna = DNATools.getDNA();
            nullModel = new UniformDistribution(dna);
            final Distribution dist = DistributionFactory.DEFAULT.createDistribution((Alphabet)dna);
            TestDistribution.randomize(dist);
            final DistributionLogo sLogo = new DistributionLogo();
            sLogo.setDistribution(dist);
            sLogo.setLogoPainter((LogoPainter)new TextLogoPainter());
            sLogo.setStyle((SymbolStyle)new DNAStyle());
            AbstractAction randomizeAction = new AbstractAction("Randomize"){

                public void actionPerformed(ActionEvent ae) {
                    TestDistribution.randomize(dist);
                    sLogo.repaint();
                }
            };
            JButton button = new JButton("Randomize");
            button.addActionListener(randomizeAction);
            JFrame f = new JFrame("Distribution Logo");
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add("Center", (Component)sLogo);
            f.getContentPane().add("South", button);
            f.setSize(300, 300);
            f.setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void randomize(Distribution dist) {
        try {
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            dtc.registerDistribution(dist);
            Iterator i = ((FiniteAlphabet)dist.getAlphabet()).iterator();
            while (i.hasNext()) {
                dtc.addCount(dist, (Symbol)i.next(), Math.random());
            }
            dtc.train();
        }
        catch (IllegalSymbolException ise) {
            throw new BioError((Throwable)ise, "This should be impossible");
        }
        catch (ChangeVetoException cve) {
            throw new BioError((Throwable)cve, "This should be impossible");
        }
    }
}

