/*
 * Decompiled with CFR 0.152.
 */
package dp;

import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;

public class Dice {
    public static void main(String[] args) {
        try {
            MarkovModel casino = Dice.createCasino();
            DP dp = DPFactory.DEFAULT.createDP(casino);
            StatePath obs_rolls = dp.generate(300);
            SymbolList roll_sequence = obs_rolls.symbolListForLabel(StatePath.SEQUENCE);
            SymbolList[] res_array = new SymbolList[]{roll_sequence};
            StatePath v = dp.viterbi(res_array, ScoreType.PROBABILITY);
            for (int i = 0; i < obs_rolls.length() / 60 + 1; ++i) {
                int j;
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(obs_rolls.symbolAt(StatePath.SEQUENCE, j + 1).getName());
                }
                System.out.print("\n");
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(obs_rolls.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                }
                System.out.print("\n");
                for (j = i * 60; j < Math.min((i + 1) * 60, obs_rolls.length()); ++j) {
                    System.out.print(v.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                }
                System.out.print("\n\n");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static MarkovModel createCasino() {
        Distribution loadedD;
        Distribution fairD;
        Symbol[] rolls = new Symbol[6];
        SimpleAlphabet diceAlphabet = new SimpleAlphabet();
        diceAlphabet.setName("DiceAlphabet");
        for (int i = 1; i < 7; ++i) {
            try {
                rolls[i - 1] = AlphabetManager.createSymbol((String)String.valueOf(i), (Annotation)Annotation.EMPTY_ANNOTATION);
                diceAlphabet.addSymbol(rolls[i - 1]);
                continue;
            }
            catch (Exception e) {
                throw new AssertionFailure("Can't create symbols to represent dice rolls", (Throwable)e);
            }
        }
        int[] advance = new int[]{1};
        try {
            fairD = DistributionFactory.DEFAULT.createDistribution((Alphabet)diceAlphabet);
            loadedD = DistributionFactory.DEFAULT.createDistribution((Alphabet)diceAlphabet);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't create distributions", (Throwable)e);
        }
        SimpleEmissionState fairS = new SimpleEmissionState("fair", Annotation.EMPTY_ANNOTATION, advance, fairD);
        SimpleEmissionState loadedS = new SimpleEmissionState("loaded", Annotation.EMPTY_ANNOTATION, advance, loadedD);
        SimpleMarkovModel casino = new SimpleMarkovModel(1, (Alphabet)diceAlphabet, "Casino");
        try {
            casino.addState((State)fairS);
            casino.addState((State)loadedS);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't add states to model", (Throwable)e);
        }
        try {
            casino.createTransition((State)casino.magicalState(), (State)fairS);
            casino.createTransition((State)casino.magicalState(), (State)loadedS);
            casino.createTransition((State)fairS, (State)casino.magicalState());
            casino.createTransition((State)loadedS, (State)casino.magicalState());
            casino.createTransition((State)fairS, (State)loadedS);
            casino.createTransition((State)loadedS, (State)fairS);
            casino.createTransition((State)fairS, (State)fairS);
            casino.createTransition((State)loadedS, (State)loadedS);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't create transitions", (Throwable)e);
        }
        try {
            for (int i = 0; i < rolls.length; ++i) {
                fairD.setWeight(rolls[i], 0.16666666666666666);
                loadedD.setWeight(rolls[i], 0.1);
            }
            loadedD.setWeight(rolls[5], 0.5);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't set emission probabilities", (Throwable)e);
        }
        try {
            Distribution dist = casino.getWeights((State)casino.magicalState());
            dist.setWeight((Symbol)fairS, 0.8);
            dist.setWeight((Symbol)loadedS, 0.2);
            dist = casino.getWeights((State)fairS);
            dist.setWeight((Symbol)loadedS, 0.04);
            dist.setWeight((Symbol)fairS, 0.95);
            dist.setWeight((Symbol)casino.magicalState(), 0.01);
            dist = casino.getWeights((State)loadedS);
            dist.setWeight((Symbol)fairS, 0.09);
            dist.setWeight((Symbol)loadedS, 0.9);
            dist.setWeight((Symbol)casino.magicalState(), 0.01);
        }
        catch (Exception e) {
            throw new AssertionFailure("Can't set transition probabilities", (Throwable)e);
        }
        return casino;
    }
}

