/*
 * Decompiled with CFR 0.152.
 */
package dp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleDotState;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.dp.twohead.DPCompiler;
import org.biojava.bio.dp.twohead.DPInterpreter;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class PairwiseAlignment {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                throw new Exception("Use: PairwiseAlignment i|c sourceSeqFile targetSeqFile\ni for interpreter (classic), c for run-time compiled (experimental)");
            }
            String ic = args[0];
            File sourceSeqFile = new File(args[1]);
            File targetSeqFile = new File(args[2]);
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            Object cfFactM = ic.equals("i") ? new DPInterpreter.Maker() : new DPCompiler(true);
            DPFactory.DefaultFactory fact = new DPFactory.DefaultFactory((CellCalculatorFactoryMaker)cfFactM);
            MarkovModel model = PairwiseAlignment.generateAligner(alpha, 0.5, 0.8, 0.2, 0.8);
            DP aligner = fact.createDP(model);
            SymbolTokenization rParser = alpha.getTokenization("token");
            FastaDescriptionLineParser.Factory sFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            FastaFormat sFormat = new FastaFormat();
            FileInputStream sourceIS = new FileInputStream(sourceSeqFile);
            StreamReader sourceI = new StreamReader((InputStream)sourceIS, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
            while (sourceI.hasNext()) {
                Sequence sourceSeq = sourceI.nextSequence();
                FileInputStream targetIS = new FileInputStream(targetSeqFile);
                StreamReader targetI = new StreamReader((InputStream)targetIS, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
                while (targetI.hasNext()) {
                    Sequence targetSeq = targetI.nextSequence();
                    Sequence[] seqs = new Sequence[]{sourceSeq, targetSeq};
                    System.out.println("Aligning " + sourceSeq.getName() + ":" + targetSeq.getName());
                    System.out.println("Forwards-:");
                    double forwardMin = aligner.forward((SymbolList[])seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + forwardMin);
                    forwardMin = aligner.forward((SymbolList[])seqs, ScoreType.ODDS);
                    System.out.println("\t" + forwardMin);
                    forwardMin = aligner.forward((SymbolList[])seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + forwardMin);
                    System.out.println("Backwards:");
                    double backward = aligner.backward((SymbolList[])seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + backward);
                    backward = aligner.backward((SymbolList[])seqs, ScoreType.ODDS);
                    System.out.println("\t" + backward);
                    backward = aligner.backward((SymbolList[])seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + backward);
                    System.out.println("Viterbi:");
                    StatePath result = aligner.viterbi((SymbolList[])seqs, ScoreType.PROBABILITY);
                    System.out.println("\t" + result.getScore());
                    result = aligner.viterbi((SymbolList[])seqs, ScoreType.ODDS);
                    System.out.println("\t" + result.getScore());
                    result = aligner.viterbi((SymbolList[])seqs, ScoreType.NULL_MODEL);
                    System.out.println("\t" + result.getScore());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static MarkovModel generateAligner(FiniteAlphabet alpha, double pMatch, double pExtendMatch, double pGap, double pExtendGap) throws Exception {
        double pEndMatch = 1.0 - pExtendMatch;
        double pEndGap = 1.0 - pExtendGap;
        double pEnd = 1.0 - pMatch - 2.0 * pGap;
        FiniteAlphabet dna = alpha;
        FiniteAlphabet dna2 = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(Collections.nCopies(2, dna));
        SimpleMarkovModel model = new SimpleMarkovModel(2, (Alphabet)dna2, "pair-wise aligner");
        UniformDistribution nullModel = new UniformDistribution(dna);
        GapDistribution gap = new GapDistribution((Alphabet)dna);
        Distribution matchDist = PairwiseAlignment.generateMatchDist(dna2);
        PairDistribution nullModel2 = new PairDistribution((Distribution)nullModel, (Distribution)nullModel);
        PairDistribution insert1Dist = new PairDistribution((Distribution)nullModel, (Distribution)gap);
        PairDistribution insert2Dist = new PairDistribution((Distribution)gap, (Distribution)nullModel);
        SimpleDotState hub = new SimpleDotState("hub");
        SimpleEmissionState match = new SimpleEmissionState("match", Annotation.EMPTY_ANNOTATION, new int[]{1, 1}, matchDist);
        SimpleEmissionState insert1 = new SimpleEmissionState("insert1", Annotation.EMPTY_ANNOTATION, new int[]{1, 0}, (Distribution)insert1Dist);
        SimpleEmissionState insert2 = new SimpleEmissionState("insert2", Annotation.EMPTY_ANNOTATION, new int[]{0, 1}, (Distribution)insert2Dist);
        model.addState((State)hub);
        model.addState((State)match);
        model.addState((State)insert1);
        model.addState((State)insert2);
        model.createTransition((State)model.magicalState(), (State)hub);
        model.createTransition((State)hub, (State)match);
        model.createTransition((State)hub, (State)insert1);
        model.createTransition((State)hub, (State)insert2);
        model.createTransition((State)hub, (State)model.magicalState());
        model.createTransition((State)match, (State)match);
        model.createTransition((State)match, (State)hub);
        model.createTransition((State)insert1, (State)insert1);
        model.createTransition((State)insert1, (State)hub);
        model.createTransition((State)insert2, (State)insert2);
        model.createTransition((State)insert2, (State)hub);
        model.getWeights((State)model.magicalState()).setWeight((Symbol)hub, 1.0);
        Distribution dist = model.getWeights((State)hub);
        dist.setWeight((Symbol)match, pMatch);
        dist.setWeight((Symbol)insert1, pGap);
        dist.setWeight((Symbol)insert2, pGap);
        dist.setWeight((Symbol)model.magicalState(), pEnd);
        dist = model.getWeights((State)match);
        dist.setWeight((Symbol)match, pExtendMatch);
        dist.setWeight((Symbol)hub, pEndMatch);
        dist = model.getWeights((State)insert1);
        dist.setWeight((Symbol)insert1, pExtendGap);
        dist.setWeight((Symbol)hub, pEndGap);
        dist = model.getWeights((State)insert2);
        dist.setWeight((Symbol)insert2, pExtendGap);
        dist.setWeight((Symbol)hub, pEndGap);
        return model;
    }

    private static Distribution generateMatchDist(FiniteAlphabet dna2) throws Exception {
        Distribution dist = DistributionFactory.DEFAULT.createDistribution((Alphabet)dna2);
        int size = dna2.size();
        int matches = (int)Math.sqrt(size);
        double pMatch = 0.15;
        double matchWeight = pMatch / (double)matches;
        double missWeigth = (1.0 - pMatch) / (double)(size - matches);
        for (BasisSymbol cps : dna2) {
            List sl = cps.getSymbols();
            if (sl.get(0) == sl.get(1)) {
                dist.setWeight((Symbol)cps, matchWeight);
                continue;
            }
            dist.setWeight((Symbol)cps, missWeigth);
        }
        return dist;
    }
}

