/*
 * Decompiled with CFR 0.152.
 */
package dp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.BaumWelchTrainer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StoppingCriteria;
import org.biojava.bio.dp.TrainingAlgorithm;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;

public class PatternFinder {
    public static void main(String[] args) throws Throwable {
        File seqFile;
        if (args.length != 2) {
            System.err.println("Use: dp.PatternFinder seqFile length");
            System.exit(1);
        }
        if (!(seqFile = new File(args[0])).exists()) {
            System.err.println("Sequence file must exist: " + seqFile);
            System.exit(1);
        }
        SequenceDB seqDB = PatternFinder.loadSequenceDB(seqFile);
        int length = Integer.parseInt(args[1]);
        MarkovModel model = PatternFinder.createModel(length);
        SingleDP dp = new SingleDP(model);
        BaumWelchTrainer bwt = new BaumWelchTrainer((DP)dp);
        StoppingCriteria sc = new StoppingCriteria(){

            public boolean isTrainingComplete(TrainingAlgorithm ta) {
                System.out.println("Cycle: " + ta.getCycle() + " score: " + ta.getCurrentScore() + " " + (ta.getCurrentScore() - ta.getLastScore()));
                return ta.getCycle() >= 5;
            }
        };
        bwt.train(seqDB, 5.0, sc);
    }

    private static SequenceDB loadSequenceDB(File seqFile) throws Throwable {
        HashSequenceDB seqDB = new HashSequenceDB();
        SequenceIterator si = SeqIOTools.readFastaDNA((BufferedReader)new BufferedReader(new FileReader(seqFile)));
        while (si.hasNext()) {
            seqDB.addSequence(si.nextSequence());
        }
        return seqDB;
    }

    private static MarkovModel createModel(int length) throws Throwable {
        int i;
        FiniteAlphabet alpha = DNATools.getDNA();
        DistributionFactory dFact = DistributionFactory.DEFAULT;
        int[] advance = new int[]{1};
        State[] pattern = new State[length];
        for (int i2 = 0; i2 < length; ++i2) {
            pattern[i2] = new SimpleEmissionState("e-" + i2, Annotation.EMPTY_ANNOTATION, advance, dFact.createDistribution((Alphabet)alpha));
        }
        SimpleEmissionState nullModel = new SimpleEmissionState("nm", Annotation.EMPTY_ANNOTATION, advance, (Distribution)new UniformDistribution(alpha));
        SimpleMarkovModel model = new SimpleMarkovModel(advance.length, (Alphabet)alpha, "pattern finder");
        for (i = 0; i < length; ++i) {
            model.addState(pattern[i]);
        }
        model.addState((State)nullModel);
        model.createTransition((State)model.magicalState(), (State)nullModel);
        model.createTransition((State)nullModel, (State)model.magicalState());
        model.createTransition((State)nullModel, (State)nullModel);
        model.createTransition((State)nullModel, pattern[0]);
        model.createTransition(pattern[length - 1], (State)nullModel);
        for (i = 1; i < length; ++i) {
            model.createTransition(pattern[i - 1], pattern[i]);
        }
        for (State s : model.stateAlphabet()) {
            if (s instanceof EmissionState) {
                EmissionState es = (EmissionState)s;
                DistributionTools.randomizeDistribution((Distribution)es.getDistribution());
            }
            DistributionTools.randomizeDistribution((Distribution)model.getWeights(s));
        }
        return model;
    }
}

