/*
 * Decompiled with CFR 0.152.
 */
package dp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.XmlMarkovModel;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ViterbiAlign {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Use: ViterbiAlign model.xml sequence.fa");
        }
        try {
            URL baseURL = new URL("file:");
            URL modelURL = new URL(baseURL, args[0]);
            File seqFile = new File(args[1]);
            Object stateFile = null;
            InputSource is = new InputSource(modelURL.openStream());
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(is);
            MarkovModel model = XmlMarkovModel.readModel((Element)doc.getDocumentElement());
            Alphabet modelAlpha = model.emissionAlphabet();
            Alphabet alpha = (Alphabet)modelAlpha.getAlphabets().get(0);
            SymbolTokenization rParser = alpha.getTokenization("token");
            DP dp = DPFactory.DEFAULT.createDP(model);
            FastaDescriptionLineParser.Factory sbFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            FastaFormat fFormat = new FastaFormat();
            Object stateI = null;
            StreamReader seqI = new StreamReader((InputStream)new FileInputStream(seqFile), (SequenceFormat)fFormat, rParser, (SequenceBuilderFactory)sbFact);
            while (seqI.hasNext()) {
                Sequence seq = seqI.nextSequence();
                SymbolList[] rl = new SymbolList[]{SymbolListViews.orderNSymbolList((SymbolList)seq, (int)modelAlpha.getAlphabets().size())};
                StatePath statePath = dp.viterbi(rl, ScoreType.PROBABILITY);
                double fScore = dp.forward(rl, ScoreType.PROBABILITY);
                double bScore = dp.backward(rl, ScoreType.PROBABILITY);
                System.out.println(seq.getName() + " viterbi: " + statePath.getScore() + ", forwards: " + fScore + ", backwards: " + bScore);
                for (int i = 0; i <= statePath.length() / 60; ++i) {
                    int j;
                    for (j = i * 60; j < Math.min((i + 1) * 60, statePath.length()); ++j) {
                        BasisSymbol x = (BasisSymbol)statePath.symbolAt(StatePath.SEQUENCE, j + 1);
                        System.out.print(rParser.tokenizeSymbol((Symbol)x.getSymbols().get(0)));
                    }
                    System.out.print("\n");
                    for (j = i * 60; j < Math.min((i + 1) * 60, statePath.length()); ++j) {
                        System.out.print(statePath.symbolAt(StatePath.STATES, j + 1).getName().charAt(0));
                    }
                    System.out.print("\n");
                    System.out.print("\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

