/*
 * Decompiled with CFR 0.152.
 */
package gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFEntrySet;
import org.biojava.bio.program.gff.GFFFilterer;
import org.biojava.bio.program.gff.GFFParser;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AnnotatedSequenceDB;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;

public class GFFToFeatures {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Use: GFFToFeatures sequence.fa features.gff");
        }
        try {
            System.out.println("Loading sequences");
            SequenceDB seqDB = GFFToFeatures.loadSequences(new File(args[0]));
            System.out.println("Sequences:");
            SequenceIterator si = seqDB.sequenceIterator();
            while (si.hasNext()) {
                Sequence seq = si.nextSequence();
                System.out.println("\t" + seq.getName());
            }
            System.out.println("Loading gff with 'hand_built' source");
            GFFEntrySet gffEntries = new GFFEntrySet();
            GFFRecordFilter.SourceFilter sFilter = new GFFRecordFilter.SourceFilter();
            sFilter.setSource("hand_built");
            GFFFilterer filterer = new GFFFilterer(gffEntries.getAddHandler(), (GFFRecordFilter)sFilter);
            GFFParser parser = new GFFParser();
            parser.parse(new BufferedReader(new InputStreamReader(new FileInputStream(new File(args[1])))), (GFFDocumentHandler)filterer);
            System.out.println("Adding features from gff to sequences");
            AnnotatedSequenceDB aSeqDB = new AnnotatedSequenceDB(seqDB, gffEntries.getAnnotator());
            System.out.println("Dumping sequence features as GFF");
            PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
            GFFWriter writer = new GFFWriter(out);
            SequencesAsGFF seqsAsGFF = new SequencesAsGFF();
            seqsAsGFF.processDB((SequenceDB)aSeqDB, (GFFDocumentHandler)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static SequenceDB loadSequences(File seqFile) throws Exception {
        HashSequenceDB seqDB = new HashSequenceDB(IDMaker.byName);
        Alphabet alpha = AlphabetManager.alphabetForName((String)"DNA");
        SymbolTokenization rParser = alpha.getTokenization("token");
        EmblProcessor.Factory sFact = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        FastaFormat sFormat = new FastaFormat();
        FileInputStream seqDBI = new FileInputStream(seqFile);
        StreamReader seqI = new StreamReader((InputStream)seqDBI, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sFact);
        while (seqI.hasNext()) {
            try {
                seqDB.addSequence(seqI.nextSequence());
            }
            catch (BioException se) {
                se.printStackTrace();
            }
        }
        return seqDB;
    }
}

