/*
 * Decompiled with CFR 0.152.
 */
package indexing;

import java.io.BufferedReader;
import java.io.File;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.bio.program.tagvalue.Indexer;
import org.biojava.bio.program.tagvalue.LineSplitParser;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.TagValueParser;
import org.biojava.bio.program.tagvalue.ValueChanger;

public class CreateSPIndex {
    public static void main(String[] args) throws Throwable {
        File storeFile = new File(args[0]);
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setPrimaryKey("ID");
        bsf.setStoreLocation(storeFile);
        bsf.addKey("AC", 10);
        bsf.addKey("ID", 10);
        BioStore store = bsf.createBioStore();
        for (int i = 1; i < args.length; ++i) {
            File spFile = new File(args[i]);
            Indexer indexer = new Indexer(spFile, (IndexStore)store);
            indexer.setPrimaryKeyName("ID");
            indexer.addSecondaryKey("AC");
            ChangeTable changeTable = new ChangeTable();
            changeTable.setChanger((Object)"ID", new ChangeTable.Changer(){

                public Object change(Object value) {
                    String s = (String)value;
                    int i = s.indexOf(" ");
                    return s.substring(0, i);
                }
            });
            changeTable.setChanger((Object)"AC", new ChangeTable.Changer(){

                public Object change(Object value) {
                    String s = (String)value;
                    int i = s.indexOf(";");
                    return s.substring(0, i);
                }
            });
            ValueChanger changer = new ValueChanger((TagValueListener)indexer, changeTable);
            Parser parser = new Parser();
            while (parser.read((BufferedReader)indexer.getReader(), (TagValueParser)LineSplitParser.EMBL, (TagValueListener)changer)) {
            }
        }
        store.commit();
    }
}

