/*
 * Decompiled with CFR 0.152.
 */
package ontology.obo;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.ontology.io.OboParser;

public class ParseBioSapiensOntology {
    public static void main(String[] args) {
        ParseBioSapiensOntology demo = new ParseBioSapiensOntology();
        demo.run();
    }

    public void run() {
        OboParser parser = new OboParser();
        InputStream inStream = this.getClass().getResourceAsStream("/files/ontology/biosapiens.obo");
        BufferedReader oboFile = new BufferedReader(new InputStreamReader(inStream));
        try {
            Ontology ontology = parser.parseOBO(oboFile, "BioSapiens", "the BioSapiens ontology");
            Set keys = ontology.getTerms();
            for (Term term : keys) {
                Object[] synonyms;
                System.out.println("TERM: " + term.getName() + " " + term.getDescription());
                System.out.println(term.getAnnotation());
                for (Object syn : synonyms = term.getSynonyms()) {
                    System.out.println(syn);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

