/*
 * Decompiled with CFR 0.152.
 */
package performance;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import performance.UserDisplay;

public class ReadFasta {
    public static void main(String[] args) {
        try {
            UserDisplay display = new UserDisplay();
            display.setTitle("BioJava performance example");
            display.setVisible(true);
            StringBuffer txt = new StringBuffer();
            txt.append("<body>");
            txt.append("<h1>BioJava performance example</h1> Read all chromosomes of Drosophila and print the length of each.<br> ");
            long start = System.currentTimeMillis();
            String fileName = "/dmel-all-chromosome-r5.8.fasta.gz";
            URL u = ReadFasta.class.getResource(fileName);
            System.out.println(u);
            String alphabet = "DNA";
            txt.append("reading " + fileName + " (47 MB)");
            System.out.println(txt);
            display.setText(txt + "</body>");
            URLConnection urlc = u.openConnection();
            InputStream inStream = urlc.getInputStream();
            if (inStream == null) {
                System.err.println("could not find file " + fileName);
                txt.append("could not find file " + fileName);
                display.setText(txt + "</body>");
                return;
            }
            display.setText(txt + "</body>");
            GZIPInputStream gzip = new GZIPInputStream(inStream);
            BufferedInputStream is = new BufferedInputStream(gzip);
            Alphabet alpha = AlphabetManager.alphabetForName((String)alphabet);
            SequenceDB db = SeqIOTools.readFasta((InputStream)is, (Alphabet)alpha);
            long maxMem = 0L;
            SequenceIterator sI = db.sequenceIterator();
            long total = 0L;
            txt.append("<table><tr><td><b>name</b></td><td><b>length</b></td></th>");
            while (sI.hasNext()) {
                Sequence seq = sI.nextSequence();
                System.out.println(seq.getName() + "\t" + seq.length());
                txt.append("<tr><td>" + seq.getName() + "</td><td>" + seq.length() + "</td></tr>");
                display.setText(txt + "</body>");
                total += (long)seq.length();
                long mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 <= maxMem) continue;
                maxMem = mem0;
            }
            txt.append("</table>");
            long mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (mem0 > maxMem) {
                maxMem = mem0;
            }
            txt.append("Total length is " + total + "<br>");
            long time = System.currentTimeMillis() - start;
            txt.append("total processing time: " + time / 1000L + " sec. " + "<br>");
            txt.append("mamimum memory: " + maxMem / 1024L / 1024L + " MB" + "<br>");
            display.setText(txt + "</body>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

