/*
 * Decompiled with CFR 0.152.
 */
package performance;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.biojavax.Namespace;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import performance.UserDisplay;

public class ReadFastaX {
    public static void main(String[] args) {
        try {
            UserDisplay display = new UserDisplay();
            display.setTitle("BioJava performance example - BioJavaX");
            display.setVisible(true);
            StringBuffer txt = new StringBuffer("<body>");
            txt.append("<h1>BioJava performance example</h1> Read all chromosomes of Drosophila and print the length of each using BioJavaX.<br> ");
            long start = System.currentTimeMillis();
            String fileName = "/dmel-all-chromosome-r5.8.fasta.gz";
            URL u = ReadFastaX.class.getResource(fileName);
            System.out.println(u);
            txt.append("reading " + fileName + " (47 MB)");
            System.out.println(txt);
            display.setText(txt + "</body>");
            URLConnection urlc = u.openConnection();
            InputStream inStream = urlc.getInputStream();
            if (inStream == null) {
                System.err.println("could not find file " + fileName);
                txt.append("could not find file " + fileName);
                display.setText(txt + "</body>");
                return;
            }
            GZIPInputStream gzip = new GZIPInputStream(inStream);
            BufferedInputStream is = new BufferedInputStream(gzip);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            SimpleNamespace ns = null;
            ns = new SimpleNamespace("biojava");
            RichSequenceIterator rsi = RichSequence.IOTools.readFastaDNA((BufferedReader)br, (Namespace)ns);
            long total = 0L;
            long maxMem = 0L;
            txt.append("<table><tr><td><b>name</b></td><td><b>length</b></td></th>");
            while (rsi.hasNext()) {
                RichSequence seq = rsi.nextRichSequence();
                total += (long)seq.length();
                System.out.println(seq.getName() + "\t" + seq.length());
                txt.append("<tr><td>" + seq.getName() + "</td><td>" + seq.length() + "</td></tr>");
                display.setText(txt + "</body>");
                long mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 <= maxMem) continue;
                maxMem = mem0;
            }
            txt.append("</table>");
            txt.append("Total length is " + total + "<br>");
            long time = System.currentTimeMillis() - start;
            txt.append("total processing time: " + time / 1000L + " sec. " + "<br>");
            txt.append("mamimum memory: " + maxMem / 1024L / 1024L + " MB" + "<br>");
            display.setText(txt + "</body>");
        }
        catch (Exception be) {
            be.printStackTrace();
            System.exit(-1);
        }
    }
}

