/*
 * Decompiled with CFR 0.152.
 */
package performance;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.SmithWaterman;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import performance.UserDisplay;

public class SmithWatermanExample {
    public static void main(String[] args) {
        try {
            String file1 = "/file1.gb";
            String file2 = "/file2.gb";
            String file3 = "/dna.mat";
            long start = System.currentTimeMillis();
            long maxMem = 0L;
            UserDisplay display = new UserDisplay();
            display.setTitle("BioJava performance example - Smith Waterman");
            display.setVisible(true);
            StringBuffer txt = new StringBuffer();
            txt.append("<body>");
            txt.append("<h1>BioJava performance example</h1>");
            txt.append("Align two sequences of approx 3000 nucleotides length using Smith Waterman.<br><br> ");
            txt.append("Reading sequence 1...<br> ");
            display.setText(txt + "</body>");
            BufferedReader b1 = SmithWatermanExample.getReader(file1);
            RichSequenceIterator rsiQuery = RichSequence.IOTools.readGenbankDNA((BufferedReader)b1, (Namespace)RichObjectFactory.getDefaultNamespace());
            txt.append("Reading sequence 2...<br> ");
            display.setText(txt + "</body>");
            BufferedReader b2 = SmithWatermanExample.getReader(file2);
            RichSequenceIterator rsiSubject = RichSequence.IOTools.readGenbankDNA((BufferedReader)b2, (Namespace)RichObjectFactory.getDefaultNamespace());
            if (rsiQuery.hasNext() && rsiSubject.hasNext()) {
                RichSequence query = rsiQuery.nextRichSequence();
                RichSequence subject = rsiSubject.nextRichSequence();
                String matrix = SmithWatermanExample.getMatrxiFromFile(file3);
                txt.append("Using matrix: <pre>" + matrix + "</pre><br>");
                txt.append("Calculating SmithWaterman of <br>");
                txt.append("query  : " + query.getDescription() + " (" + query.getName() + ")<br>");
                txt.append("subject: " + subject.getDescription() + " (" + subject.getName() + ")<br>");
                short match = 0;
                short replace = 5;
                short insert = 2;
                short delete = 2;
                short gapExtend = 1;
                txt.append("using penalties: match (" + match + "), replace (" + replace + ")," + " insert (" + insert + " ) delete (" + delete + ")," + " gapExtend (" + gapExtend + ") <br>");
                display.setText(txt + "</body>");
                SubstitutionMatrix smax = new SubstitutionMatrix((FiniteAlphabet)query.getAlphabet(), matrix, file3);
                long mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 > maxMem) {
                    maxMem = mem0;
                }
                SmithWaterman sa = new SmithWaterman(match, replace, insert, delete, gapExtend, smax);
                mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 > maxMem) {
                    maxMem = mem0;
                }
                sa.pairwiseAlignment((SymbolList)query, (SymbolList)subject);
                mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 > maxMem) {
                    maxMem = mem0;
                }
                txt.append("done...<br> <pre>");
                txt.append(sa.getAlignmentString());
                long time = System.currentTimeMillis() - start;
                mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (mem0 > maxMem) {
                    maxMem = mem0;
                }
                txt.append("<pre>");
                txt.append("total processing time: " + time / 1000L + " sec. " + "<br>");
                txt.append("mamimum memory: " + maxMem / 1024L / 1024L + " MB" + "<br>");
                display.setText(txt + "</body>");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BufferedReader getReader(String fileName) throws IOException {
        URL u = SmithWatermanExample.class.getResource(fileName);
        System.out.println(u);
        if (u == null) {
            System.err.println("could not find file " + fileName);
            throw new IOException("could not find file " + fileName);
        }
        URLConnection urlc = u.openConnection();
        InputStream inStream = urlc.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(inStream));
        return r;
    }

    private static String getMatrxiFromFile(String fileName) throws IOException {
        BufferedReader reader = SmithWatermanExample.getReader(fileName);
        StringBuffer matString = new StringBuffer();
        while (reader.ready()) {
            matString.append(reader.readLine() + System.getProperty("line.separator"));
        }
        reader.close();
        return matString.toString();
    }
}

