/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class MotifFinder2 {
    public static void main(String[] args) throws BioException, IOException {
        if (args.length < 2) {
            System.err.println("Usage: seq.MotifFinder2 <motif> <seqfile.fasta>");
        }
        SymbolList motif = DNATools.createDNA((String)args[0]);
        int motLength = motif.length();
        SymbolList reverseMotif = DNATools.reverseComplement((SymbolList)motif);
        int count = 0;
        String fileName = args[1];
        FileReader stream = new FileReader(fileName);
        BufferedReader br = new BufferedReader(stream);
        RichSequenceIterator si = RichSequence.IOTools.readFastaDNA((BufferedReader)br, (Namespace)RichObjectFactory.getDefaultNamespace());
        while (si.hasNext()) {
            RichSequence sequence = si.nextRichSequence();
            int seqLength = sequence.length();
            for (int pos = 1; pos <= seqLength - motLength + 1; ++pos) {
                SymbolList sub = sequence.subList(pos, pos + motLength - 1);
                if (MotifFinder2.compare(sub, motif)) {
                    ++count;
                    MotifFinder2.report(sequence.getName(), sub.seqString(), pos, pos + motLength - 1, "+");
                }
                if (!MotifFinder2.compare(sub, reverseMotif)) continue;
                ++count;
                MotifFinder2.report(sequence.getName(), sub.seqString(), pos, pos + motLength - 1, "-");
            }
        }
        System.out.println("found " + count + " instances of " + motif.seqString());
    }

    private static void report(String name, String result, int start, int end, String strand) {
        System.out.println(name + ":" + result + '\t' + start + '\t' + end + '\t' + strand);
    }

    private static boolean compare(SymbolList sl1, SymbolList sl2) throws BioException {
        if (sl1.length() != sl2.length()) {
            throw new BioException("Lengths don't match");
        }
        for (int pos = 1; pos <= sl1.length(); ++pos) {
            boolean status = false;
            Symbol symbolA = sl1.symbolAt(pos);
            FiniteAlphabet A = (FiniteAlphabet)symbolA.getMatches();
            Symbol symbolB = sl2.symbolAt(pos);
            FiniteAlphabet B = (FiniteAlphabet)symbolB.getMatches();
            Iterator ia = A.iterator();
            int hits = 0;
            while (ia.hasNext()) {
                Symbol s = (Symbol)ia.next();
                if (!B.contains(s)) continue;
                ++hits;
                break;
            }
            if (hits != 0) continue;
            return false;
        }
        return true;
    }
}

