/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import org.biojava.bio.seq.Sequence;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class TestEmbl {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: seq.TestEmbl emblFile");
            }
            File emblFile = new File(args[0]);
            BufferedReader br = new BufferedReader(new FileReader(emblFile));
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            RichSequenceIterator seqI = RichSequence.IOTools.readEMBLDNA((BufferedReader)br, (Namespace)ns);
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                System.out.println(seq.getName() + " has " + seq.countFeatures() + " features and " + seq.getComments().size() + " comments");
                RichSequence.IOTools.writeEMBL((OutputStream)System.out, (Sequence)seq, (Namespace)ns);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

