/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import org.biojava.bio.seq.Sequence;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class TestGenbank {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: seq.TestGenbank genbankFile");
            }
            File genbankFile = new File(args[0]);
            BufferedReader gReader = new BufferedReader(new InputStreamReader(new FileInputStream(genbankFile)));
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            RichSequenceIterator seqI = RichSequence.IOTools.readGenbankDNA((BufferedReader)gReader, (Namespace)ns);
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                System.out.println(seq.toString() + " has " + seq.countFeatures() + " features");
                Iterator i = seq.features();
                while (i.hasNext()) {
                    RichFeature f = (RichFeature)i.next();
                    System.out.println("\t" + f.getType() + "\t" + f.getLocation() + "\t" + f.getAnnotation().asMap());
                }
                RichAnnotation theAnnotation = (RichAnnotation)seq.getAnnotation();
                Iterator notesIterator = theAnnotation.getNoteSet().iterator();
                while (notesIterator.hasNext()) {
                    System.out.println();
                    Note note = (Note)notesIterator.next();
                    System.out.println(note);
                }
                System.out.println("\n\nRE-GENERATING GENBANK");
                RichSequence.IOTools.writeGenbank((OutputStream)System.out, (Sequence)seq, (Namespace)ns);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

