/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Set;
import org.biojavax.Namespace;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class TestRefSeqPrt {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: seq.TestRefSeqPrt refseqFile");
            }
            File genbankFile = new File(args[0]);
            BufferedReader gReader = new BufferedReader(new InputStreamReader(new FileInputStream(genbankFile)));
            Namespace ns = (Namespace)RichObjectFactory.getObject(SimpleNamespace.class, (Object[])new Object[]{"ref"});
            RichSequenceIterator seqI = RichSequence.IOTools.readGenbankProtein((BufferedReader)gReader, (Namespace)ns);
            while (seqI.hasNext()) {
                RichSequence seq = seqI.nextRichSequence();
                System.out.println(seq.toString() + " has " + seq.countFeatures() + " features");
                System.out.println("\tand is " + seq.length());
                RichAnnotation theAnnotation = (RichAnnotation)seq.getAnnotation();
                Set notes = seq.getNoteSet();
                Iterator theOtherIterator = notes.iterator();
                while (theOtherIterator.hasNext()) {
                    System.out.println();
                    Object note = theOtherIterator.next();
                    System.out.println(note);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

