/*
 * Decompiled with CFR 0.152.
 */
package seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;

public class TestSwissprot {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Use: TestSwissProt swissprotFile");
            }
            File swissProtFile = new File(args[0]);
            EmblLikeFormat sFormat = new EmblLikeFormat();
            BufferedReader sReader = new BufferedReader(new InputStreamReader(new FileInputStream(swissProtFile)));
            SwissprotProcessor.Factory sbFact = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            SymbolTokenization rParser = alpha.getTokenization("token");
            StreamReader seqI = new StreamReader(sReader, (SequenceFormat)sFormat, rParser, (SequenceBuilderFactory)sbFact);
            while (seqI.hasNext()) {
                Sequence seq = seqI.nextSequence();
                System.out.println(seq.getName() + " has " + seq.countFeatures() + " features");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

