/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.bio.gui.sequence.BeadFeatureRenderer;
import org.biojava.bio.gui.sequence.EllipticalBeadRenderer;
import org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.RectangularBeadRenderer;
import org.biojava.bio.gui.sequence.RulerRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SymbolSequenceRenderer;
import org.biojava.bio.gui.sequence.TranslatedSequencePanel;
import org.biojava.bio.gui.sequence.ZiggyFeatureRenderer;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.SymbolList;

public class FastBeadDemo {
    private static final int INITIAL_SCALE = 30;
    private JFrame frame;
    private JButton horiz;
    private JButton vert;
    private JLabel scaleLabel;
    private JSlider scale;
    private static JScrollBar bar;
    private static TranslatedSequencePanel seqPanel;

    public FastBeadDemo() {
        this.initComponents();
    }

    private void initComponents() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        Box controlBox = Box.createHorizontalBox();
        this.horiz = new JButton("Horizontal");
        this.vert = new JButton("Vertical");
        this.scaleLabel = new JLabel("Scale");
        this.scale = new JSlider(0, 1, 100, 30);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(this.horiz);
        controlBox.add(Box.createHorizontalStrut(10));
        controlBox.add(this.vert);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(this.scaleLabel);
        controlBox.add(Box.createHorizontalStrut(5));
        controlBox.add(this.scale);
        controlBox.add(Box.createHorizontalGlue());
        seqPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.frame.getContentPane().add((Component)controlBox, "North");
        this.frame.getContentPane().add((Component)seqPanel, "Center");
        bar = new JScrollBar(0);
        this.frame.getContentPane().add((Component)bar, "South");
        bar.addAdjustmentListener(new BarListener());
        this.horiz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FastBeadDemo.this.horizActionPerformed(ae);
            }
        });
        this.vert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FastBeadDemo.this.vertActionPerformed(ae);
            }
        });
        this.scale.addChangeListener(new SliderListener());
        this.frame.setSize(800, 200);
        this.frame.setVisible(true);
    }

    private void vertActionPerformed(ActionEvent ae) {
        seqPanel.setDirection(1);
    }

    private void horizActionPerformed(ActionEvent ae) {
        seqPanel.setDirection(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("Usage: FastBeadDemo <EMBL file>");
            System.exit(0);
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(argv[0]));
            SequenceIterator seqi = SeqIOTools.readEmbl((BufferedReader)reader);
            seqPanel = new TranslatedSequencePanel();
            if (seqi.hasNext()) {
                Sequence seq = seqi.nextSequence();
                Feature source = (Feature)seq.filter((FeatureFilter)new FeatureFilter.ByType("source"), false).features().next();
                seq.removeFeature(source);
                seqPanel.setSequence((SymbolList)seq);
                seqPanel.setScale(Math.exp(-4.285714285714286) * 20.0);
                seqPanel.setDirection(0);
                seqPanel.addSequenceViewerListener(new SequenceViewerListener(){

                    public void mouseClicked(SequenceViewerEvent sve) {
                        System.out.println(sve.getMouseEvent().getPoint() + "\t" + sve.getSource());
                        Object t = sve.getTarget();
                        for (SequenceRenderer sr : sve.getPath()) {
                            System.out.println("\t" + sr);
                        }
                        if (t instanceof FeatureHolder) {
                            FeatureHolder fh = (FeatureHolder)t;
                            Iterator fi = fh.features();
                            while (fi.hasNext()) {
                                Feature f = (Feature)fi.next();
                                System.out.println("\t" + f.getType() + "\t: " + f.getLocation());
                            }
                        }
                    }

                    public void mousePressed(SequenceViewerEvent sve) {
                    }

                    public void mouseReleased(SequenceViewerEvent sve) {
                    }
                });
                FeatureFilter.ByType cds = new FeatureFilter.ByType("CDS");
                FeatureFilter.ByType mrna = new FeatureFilter.ByType("mRNA");
                FeatureFilter.ByType rep = new FeatureFilter.ByType("repeat_region");
                FeatureFilter.ByType misc = new FeatureFilter.ByType("misc_feature");
                FeatureFilter.StrandFilter rev = new FeatureFilter.StrandFilter(StrandedFeature.NEGATIVE);
                EllipticalBeadRenderer erGreen = new EllipticalBeadRenderer(10.0, 21.0, (Paint)Color.black, (Paint)Color.green, (Stroke)new BasicStroke(), 2.0);
                EllipticalBeadRenderer erRed = new EllipticalBeadRenderer(10.0, 22.0, (Paint)Color.black, (Paint)Color.red, (Stroke)new BasicStroke(), 2.0);
                RectangularBeadRenderer rrWhite = new RectangularBeadRenderer(10.0, 0.0, (Paint)Color.black, (Paint)Color.white, (Stroke)new BasicStroke());
                RectangularBeadRenderer rrBlue = new RectangularBeadRenderer(10.0, 11.0, (Paint)Color.black, (Paint)Color.blue, (Stroke)new BasicStroke());
                RectangularBeadRenderer rrYellow = new RectangularBeadRenderer(10.0, 11.0, (Paint)Color.black, (Paint)Color.yellow, (Stroke)new BasicStroke());
                ZiggyFeatureRenderer ziggyCDS = new ZiggyFeatureRenderer();
                ZiggyFeatureRenderer ziggyRNA = new ZiggyFeatureRenderer();
                rrWhite.setDelegateRenderer((OptimizableFilter)misc, (BeadFeatureRenderer)erGreen);
                rrWhite.setDelegateRenderer((OptimizableFilter)rep, (BeadFeatureRenderer)rrBlue);
                erGreen.setDelegateRenderer((OptimizableFilter)rev, (BeadFeatureRenderer)erRed);
                rrBlue.setDelegateRenderer((OptimizableFilter)rev, (BeadFeatureRenderer)rrYellow);
                FeatureBlockSequenceRenderer fbrCDS = new FeatureBlockSequenceRenderer();
                FeatureBlockSequenceRenderer fbrRNA = new FeatureBlockSequenceRenderer();
                FeatureBlockSequenceRenderer other = new FeatureBlockSequenceRenderer();
                fbrCDS.setFeatureRenderer((FeatureRenderer)ziggyCDS);
                fbrRNA.setFeatureRenderer((FeatureRenderer)ziggyRNA);
                other.setFeatureRenderer((FeatureRenderer)rrWhite);
                MultiLineRenderer multi = new MultiLineRenderer();
                multi.addRenderer((SequenceRenderer)new FilteringRenderer((SequenceRenderer)fbrCDS, (FeatureFilter)cds, false));
                multi.addRenderer((SequenceRenderer)new FilteringRenderer((SequenceRenderer)fbrRNA, (FeatureFilter)mrna, false));
                multi.addRenderer((SequenceRenderer)other);
                multi.addRenderer((SequenceRenderer)new SymbolSequenceRenderer());
                multi.addRenderer((SequenceRenderer)new RulerRenderer());
                seqPanel.setRenderer((SequenceRenderer)multi);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        FastBeadDemo demo = new FastBeadDemo();
        bar.setValues(0, 10, 0, seqPanel.getSequence().length());
    }

    private class BarListener
    implements AdjustmentListener {
        private BarListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent ae) {
            JScrollBar source = (JScrollBar)ae.getAdjustable();
            int translation = source.getValue();
            seqPanel.setSymbolTranslation(translation);
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        public void stateChanged(ChangeEvent ce) {
            JSlider source = (JSlider)ce.getSource();
            if (!source.getValueIsAdjusting()) {
                int val = source.getValue();
                double s = Math.exp((double)(-val) / 7.0) * 20.0;
                seqPanel.setScale(s);
                int seqVisible = seqPanel.getVisibleSymbolCount() - seqPanel.getSymbolTranslation();
                int seqTotal = seqPanel.getSequence().length();
                int extent = Math.min(seqVisible, seqTotal - 1);
                int barMin = bar.getMinimum();
                int barMax = bar.getMaximum();
                int barVal = bar.getValue();
                if (extent + barVal >= barMax) {
                    barVal = Math.max(0, barMax - extent);
                }
                bar.setValues(barVal, extent, 0, barMax);
            }
        }
    }
}

