/*
 * Decompiled with CFR 0.152.
 */
package seqviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.biojava.bio.Annotation;
import org.biojava.bio.gui.sequence.AbiTraceRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.RulerRenderer;
import org.biojava.bio.gui.sequence.SequencePanel;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SymbolSequenceRenderer;
import org.biojava.bio.program.abi.ABITrace;
import org.biojava.bio.seq.SequenceTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class TraceViewer {
    public static void main(String[] args) throws Exception {
        File abiFile = new File(args[0]);
        ABITrace trace = new ABITrace(abiFile);
        AbiTraceRenderer traceRenderer = new AbiTraceRenderer();
        traceRenderer.setTrace(trace);
        traceRenderer.setDepth(300.0);
        MultiLineRenderer mlr = new MultiLineRenderer();
        mlr.addRenderer((SequenceRenderer)traceRenderer);
        mlr.addRenderer((SequenceRenderer)new SymbolSequenceRenderer());
        mlr.addRenderer((SequenceRenderer)new RulerRenderer());
        SequencePanel sp = new SequencePanel();
        sp.setSequence((SymbolList)SequenceTools.createSequence((SymbolList)trace.getSequence(), (String)abiFile.toString(), (String)abiFile.toString(), (Annotation)Annotation.EMPTY_ANNOTATION));
        sp.setDirection(0);
        sp.setScale(8.0);
        sp.setRange(new RangeLocation(1, sp.getSymbols().length()));
        sp.setRenderer((SequenceRenderer)mlr);
        JFrame frame = new JFrame("Trace: " + abiFile);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JScrollPane((Component)sp), "Center");
        frame.setSize(800, 400);
        frame.setVisible(true);
    }
}

