/*
 * Decompiled with CFR 0.152.
 */
package ssbind;

import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.search.SearchContentFilter;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.bio.search.SimpleSeqSimilaritySearchSubHit;
import org.biojava.bio.seq.StrandParser;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alignment;
import ssbind.AlignmentBuilder;

public class SubHitBuilder
extends SearchContentFilter {
    public static final Object SEARCH_SUB_HIT = SubHitBuilder.class.toString() + ".SEARCH_SUB_HIT";
    private Alignment alignment;
    private double eValue;
    private double pValue;
    private double score;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;

    public SubHitBuilder(SearchContentHandler delegate) {
        super(delegate);
    }

    public void startSubHit() {
        this.alignment = null;
        this.eValue = Double.NaN;
        this.pValue = Double.NaN;
        this.score = 0.0;
        this.subjectStart = Integer.MIN_VALUE;
        this.subjectEnd = Integer.MAX_VALUE;
        this.subjectStrand = StrandedFeature.UNKNOWN;
        this.queryStart = Integer.MIN_VALUE;
        this.queryEnd = Integer.MAX_VALUE;
        this.queryStrand = StrandedFeature.UNKNOWN;
    }

    public void addSubHitProperty(Object key, Object val) {
        if ("expectedValue".equals(key)) {
            this.eValue = Double.parseDouble((String)val);
        } else if ("score".equals(key)) {
            this.score = Double.parseDouble((String)val);
        } else if ("subjectSequenceStart".equals(key)) {
            this.subjectStart = Integer.parseInt((String)val);
        } else if ("subjectSequenceEnd".equals(key)) {
            this.subjectEnd = Integer.parseInt((String)val);
        } else if ("subjectStrand".equals(key)) {
            this.subjectStrand = StrandParser.parseStrand((String)((String)val));
        } else if ("querySequenceStart".equals(key)) {
            this.queryStart = Integer.parseInt((String)val);
        } else if ("querySequenceEnd".equals(key)) {
            this.queryEnd = Integer.parseInt((String)val);
        } else if ("queryStrand".equals(key)) {
            this.queryStrand = StrandParser.parseStrand((String)((String)val));
        } else if (AlignmentBuilder.ALIGNMENT.equals(key)) {
            this.alignment = (Alignment)val;
        } else {
            super.addSubHitProperty(key, val);
        }
    }

    public void endSubHit() {
        super.addSubHitProperty(SEARCH_SUB_HIT, (Object)new SimpleSeqSimilaritySearchSubHit(this.score, this.eValue, this.pValue, Math.min(this.queryStart, this.queryEnd), Math.max(this.queryStart, this.queryEnd), this.queryStrand, Math.min(this.subjectStart, this.subjectEnd), Math.max(this.subjectStart, this.subjectEnd), this.subjectStrand, this.alignment, (Annotation)new SmallAnnotation()));
        super.endSubHit();
    }
}

