/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.PDBFileReader;

public class LoadStructure {
    public static void main(String[] args) {
        LoadStructure demo = new LoadStructure();
        if (args.length == 0) {
            demo.readStructureFromStream();
        } else {
            demo.loadStructure(args[0]);
        }
        demo.loadStructureById();
    }

    public Structure loadStructureById() {
        String path = "/path/to/PDB/directory";
        PDBFileReader pdbreader = new PDBFileReader();
        pdbreader.setPath(path);
        Structure structure = null;
        try {
            structure = pdbreader.getStructureById("5pti");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return structure;
    }

    public Structure loadStructure(String pathToPDBFile) {
        PDBFileReader pdbreader = new PDBFileReader();
        Structure structure = null;
        try {
            structure = pdbreader.getStructure(pathToPDBFile);
            System.out.println(structure);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return structure;
    }

    public Structure readStructureFromStream() {
        InputStream inStream = this.getClass().getResourceAsStream("/files/5pti.pdb");
        Structure structure = null;
        PDBFileParser pdbpars = new PDBFileParser();
        try {
            structure = pdbpars.parsePDBFile(inStream);
            System.out.println(structure);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return structure;
    }
}

