/*
 * Decompiled with CFR 0.152.
 */
package structure;

import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.gui.BiojavaJmol;
import org.biojava.bio.structure.io.PDBFileReader;

public class PDBView {
    public static void main(String[] args) {
        if (args.length < 1 || !BiojavaJmol.jmolInClassPath()) {
            PDBView.printHelp();
            return;
        }
        String pdbFile = args[0];
        PDBView view = new PDBView();
        view.show(pdbFile);
    }

    public static void printHelp() {
        System.out.println("Usage: PDBView <pdbfilename>");
        System.out.println("Make sure that Jmol is installed in your classpath.");
    }

    public void show(String pdbFileName) {
        PDBFileReader pdbreader = new PDBFileReader();
        try {
            Structure pdb = pdbreader.getStructure(pdbFileName);
            BiojavaJmol jmol = new BiojavaJmol();
            jmol.setStructure(pdb);
            jmol.evalString("select * ; color chain;");
            jmol.evalString("select *; spacefill off; wireframe off; backbone 0.4;  ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

