/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.List;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import structure.LoadStructure;

public class PhiPsiCalculation {
    public static void main(String[] args) {
        LoadStructure demo1 = new LoadStructure();
        Structure structure = demo1.readStructureFromStream();
        PhiPsiCalculation demo2 = new PhiPsiCalculation();
        demo2.calcPhiPsi(structure);
    }

    public void calcPhiPsi(Structure structure) {
        Chain chain = structure.getChain(0);
        List groups = chain.getAtomGroups("amino");
        for (int i = 0; i < groups.size(); ++i) {
            AminoAcid b = (AminoAcid)groups.get(i);
            double phi = 360.0;
            double psi = 360.0;
            if (i > 0) {
                AminoAcid a = (AminoAcid)groups.get(i - 1);
                try {
                    phi = Calc.getPhi((AminoAcid)a, (AminoAcid)b);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                    phi = 360.0;
                }
            }
            if (i < groups.size() - 1) {
                AminoAcid c = (AminoAcid)groups.get(i + 1);
                try {
                    psi = Calc.getPsi((AminoAcid)b, (AminoAcid)c);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                    psi = 360.0;
                }
            }
            System.out.print(b.getPDBCode() + " " + b.getPDBName() + ":");
            System.out.println(String.format("\tphi: %+7.2f psi: %+7.2f", phi, psi));
        }
    }
}

