/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.gui.BiojavaJmol;
import org.biojava.bio.structure.io.PDBFileParser;

public class SuperimposeStructures {
    public static void main(String[] args) {
        SuperimposeStructures demo = new SuperimposeStructures();
        demo.run();
    }

    public void run() {
        InputStream inStream1 = this.getClass().getResourceAsStream("/files/5pti.pdb");
        InputStream inStream2 = this.getClass().getResourceAsStream("/files/1tap.pdb");
        Structure structure1 = null;
        Structure structure2 = null;
        PDBFileParser pdbpars = new PDBFileParser();
        try {
            structure1 = pdbpars.parsePDBFile(inStream1);
            structure2 = pdbpars.parsePDBFile(inStream2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StructurePairAligner aligner = new StructurePairAligner();
        try {
            String[] pdb2;
            String[] pdb1;
            aligner.align(structure1, structure2);
            AlternativeAlignment[] aligs = aligner.getAlignments();
            AlternativeAlignment a = aligs[0];
            System.out.println(a);
            if (!BiojavaJmol.jmolInClassPath()) {
                System.err.println("Could not find Jmol in classpath, please install first!");
                return;
            }
            Structure artificial = a.getAlignedStructure(structure1, structure2);
            BiojavaJmol jmol = new BiojavaJmol();
            jmol.setTitle(artificial.getName());
            jmol.setStructure(artificial);
            jmol.evalString("select *; backbone 0.4; wireframe off; spacefill off; select not protein and not solvent; spacefill on;");
            jmol.evalString("select */1 ; color red; model 1; ");
            for (String res : pdb1 = a.getPDBresnum1()) {
                jmol.evalString("select " + res + "/1 ; backbone 0.6; color white;");
            }
            jmol.evalString("select */2; color blue; model 2;");
            for (String res : pdb2 = a.getPDBresnum2()) {
                jmol.evalString("select " + res + "/2 ; backbone 0.6; color yellow;");
            }
            jmol.evalString("model 0;");
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }
}

