/*
 * Decompiled with CFR 0.152.
 */
package tagvalue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.Annotation;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.program.formats.Format;
import org.biojava.bio.program.formats.FormatTools;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ChangeVetoException;

public class Grep {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            Grep.useageAndExit();
        }
        String formatName = args[0];
        Format format = FormatTools.getFormat((String)formatName);
        System.err.println("Using format: " + format.getLSID());
        String searchList = args[1];
        String displayList = args[2];
        Reporter listener = new Reporter(searchList, displayList);
        ParserListener pl = format.getParserListener((TagValueListener)listener);
        Parser parser = new Parser();
        for (int i = 3; i < args.length; ++i) {
            BufferedReader reader = new BufferedReader(new FileReader(new File(args[i])));
            while (parser.read(reader, pl.getParser(), pl.getListener())) {
            }
        }
    }

    private static void useageAndExit() {
        System.err.println("Use: tagvalue.Grep toMatch toPrintList fileList");
        System.err.println("\tformat\t: format name. One of");
        System.err.println("\t\tthe name of a class in org.biojava.bio.program.format");
        System.err.println("\t\tfully qualified class name");
        System.err.println("\t\tEither way, the class must be castable to");
        System.err.println("\t\torg.biojava.bio.program.formats.Format.");
        System.exit(1);
    }

    private static class Reporter
    implements TagValueListener {
        private final String searchKey;
        private final Pattern searchVal;
        private final Set dumpVals = new HashSet();
        private int depth;
        private Object tag;
        private boolean shouldDump;
        private boolean goodTag;
        private boolean dumpTag;
        private Annotation values;

        public Reporter(String searchList, String displayList) throws Exception {
            Pattern slp = Pattern.compile("([^=]+)=([^=]+)");
            Matcher slm = slp.matcher(searchList);
            if (!slm.matches()) {
                throw new Exception("Can't match " + searchList + " to " + slp.pattern());
            }
            this.searchKey = slm.group(1);
            this.searchVal = Pattern.compile(slm.group(2));
            Pattern dlp = Pattern.compile("[^,]+");
            Matcher dlm = dlp.matcher(displayList);
            while (dlm.find()) {
                this.dumpVals.add(dlm.group(0));
            }
            this.depth = 0;
        }

        public void startRecord() {
            if (this.depth == 0) {
                this.shouldDump = false;
                this.values = new SimpleAnnotation();
            }
            ++this.depth;
        }

        public void endRecord() {
            --this.depth;
            if (this.depth == 0 && this.shouldDump) {
                System.out.println(this.values);
            }
        }

        public void startTag(Object tag) {
            this.tag = tag;
            this.goodTag = tag.equals(this.searchKey);
            this.dumpTag = this.dumpVals.contains(tag);
        }

        public void endTag() {
            this.goodTag = false;
            this.dumpTag = false;
        }

        public void value(TagValueContext ctxt, Object value) {
            if (this.goodTag && this.searchVal.matcher(value.toString()).find()) {
                this.shouldDump = true;
            }
            if (this.dumpTag) {
                try {
                    this.values.setProperty(this.tag, value);
                }
                catch (ChangeVetoException e) {
                    throw new Error(e);
                }
            }
        }
    }
}

