/*
 * Decompiled with CFR 0.152.
 */
package tagvalue;

import java.io.BufferedReader;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.program.formats.Format;
import org.biojava.bio.program.formats.FormatTools;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.tagvalue.Indexer;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.tagvalue.TagValueListener;

public class Index {
    public static void main(String[] args) throws Exception {
        String storeName = args[0];
        File storeFile = new File(args[1]);
        String formatName = args[2];
        String idAndLen = args[3];
        String[] scndrysAndLen = args[4].split(":");
        Format format = FormatTools.getFormat((String)formatName);
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreLocation(storeFile);
        bsf.setSequenceFormat(format.getLSID());
        Pattern idLenPat = Pattern.compile("(\\S+),(\\d+))");
        Matcher idMatcher = idLenPat.matcher(idAndLen);
        if (!idMatcher.matches()) {
            Index.doIdLenError(idAndLen);
        }
        bsf.setPrimaryKey(idMatcher.group(1));
        bsf.addKey(idMatcher.group(1), Integer.parseInt(idMatcher.group(2)));
        for (int i = 0; i < scndrysAndLen.length; ++i) {
            Matcher m = idLenPat.matcher(scndrysAndLen[i]);
            if (!m.matches()) {
                Index.doIdLenError(scndrysAndLen[i]);
            }
            bsf.addKey(m.group(1), Integer.parseInt(m.group(2)));
        }
        BioStore store = bsf.createBioStore();
        Indexer indexer = new Indexer(storeFile, (IndexStore)store);
        String pk = bsf.getPrimaryKey();
        indexer.setPrimaryKeyName(bsf.getPrimaryKey());
        for (String key : bsf.getKeys()) {
            if (key.equals(pk)) continue;
            indexer.addSecondaryKey(key);
        }
        Parser parser = new Parser();
        ParserListener pl = format.getParserListener((TagValueListener)indexer);
        while (parser.read((BufferedReader)indexer.getReader(), pl.getParser(), pl.getListener())) {
        }
        store.commit();
    }

    private static void doIdLenError(String idLen) {
        System.err.println("Could not process " + idLen);
        System.err.println("Expecting <fieldName>,<length>");
        System.exit(1);
    }
}

