/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.turbine.binder.CanonicalTypeBinder;
import com.google.turbine.binder.ClassPathBinder;
import com.google.turbine.binder.ConstBinder;
import com.google.turbine.binder.ConstEvaluator;
import com.google.turbine.binder.DisambiguateTypeAnnotations;
import com.google.turbine.binder.HierarchyBinder;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.TypeBinder;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.SourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.ImportIndex;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.lookup.WildImportIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import com.google.turbine.type.Type;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Binder {
    public static BindingResult bind(List<Tree.CompUnit> units, Iterable<Path> classpath, Iterable<Path> bootclasspath) throws IOException {
        TopLevelIndex.Builder tliBuilder = TopLevelIndex.builder();
        LinkedHashMultimap toplevels = LinkedHashMultimap.create();
        SimpleEnv<ClassSymbol, SourceBoundClass> ienv = Binder.bindSourceBoundClasses((Multimap<Tree.CompUnit, ClassSymbol>)toplevels, units, tliBuilder);
        ImmutableSet syms = ienv.asMap().keySet();
        CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv = ClassPathBinder.bind(classpath, bootclasspath, tliBuilder);
        TopLevelIndex tli = tliBuilder.build();
        SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv = Binder.bindPackages(ienv, tli, (Multimap<Tree.CompUnit, ClassSymbol>)toplevels, classPathEnv);
        Env<ClassSymbol, SourceHeaderBoundClass> henv = Binder.bindHierarchy((Iterable<ClassSymbol>)syms, psenv, classPathEnv);
        Env<ClassSymbol, SourceTypeBoundClass> tenv = Binder.bindTypes((ImmutableSet<ClassSymbol>)syms, henv, CompoundEnv.of(classPathEnv).append(henv));
        tenv = Binder.constants((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        tenv = Binder.disambiguateTypeAnnotations((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        tenv = Binder.canonicalizeTypes((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            result.put((Object)sym, (Object)tenv.get(sym));
        }
        return new BindingResult((ImmutableMap<ClassSymbol, SourceTypeBoundClass>)result.build(), classPathEnv);
    }

    static SimpleEnv<ClassSymbol, SourceBoundClass> bindSourceBoundClasses(Multimap<Tree.CompUnit, ClassSymbol> toplevels, List<Tree.CompUnit> units, TopLevelIndex.Builder tliBuilder) {
        SimpleEnv.Builder<ClassSymbol, SourceBoundClass> envbuilder = SimpleEnv.builder();
        for (Tree.CompUnit unit : units) {
            String packagename;
            Object decls = unit.decls();
            if (unit.pkg().isPresent()) {
                Tree.PkgDecl pkgDecl = (Tree.PkgDecl)unit.pkg().get();
                packagename = Joiner.on((char)'/').join(pkgDecl.name()) + '/';
                if (!pkgDecl.annos().isEmpty()) {
                    decls = Iterables.concat(decls, (Iterable)ImmutableList.of((Object)Binder.packageInfoTree(pkgDecl)));
                }
            } else {
                packagename = "";
            }
            for (Tree.TyDecl decl : decls) {
                ClassSymbol sym = new ClassSymbol(packagename + decl.name());
                ImmutableMap<String, ClassSymbol> children = Binder.bindSourceBoundClassMembers(envbuilder, sym, decl.members(), toplevels, unit, decl.tykind());
                if (envbuilder.putIfAbsent(sym, new SourceBoundClass(decl, null, decl.tykind(), children, Binder.access(null, decl.mods())))) {
                    toplevels.put((Object)unit, (Object)sym);
                }
                tliBuilder.insert(sym);
            }
        }
        return envbuilder.build();
    }

    private static int access(TurbineTyKind enclosing, ImmutableSet<TurbineModifier> mods) {
        int access = 0;
        for (TurbineModifier m : mods) {
            access |= m.flag();
        }
        if (enclosing != null) {
            switch (enclosing) {
                case INTERFACE: 
                case ANNOTATION: {
                    access = TurbineVisibility.PUBLIC.setAccess(access);
                    break;
                }
            }
        }
        return access;
    }

    private static Tree.TyDecl packageInfoTree(Tree.PkgDecl pkgDecl) {
        return new Tree.TyDecl(pkgDecl.position(), (Set<TurbineModifier>)ImmutableSet.of((Object)((Object)TurbineModifier.ACC_SYNTHETIC)), pkgDecl.annos(), "package-info", (ImmutableList<Tree.TyParam>)ImmutableList.of(), (Optional<Tree.ClassTy>)Optional.absent(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), (ImmutableList<Tree>)ImmutableList.of(), TurbineTyKind.INTERFACE);
    }

    private static ImmutableMap<String, ClassSymbol> bindSourceBoundClassMembers(SimpleEnv.Builder<ClassSymbol, SourceBoundClass> env, ClassSymbol owner, ImmutableList<Tree> members, Multimap<Tree.CompUnit, ClassSymbol> toplevels, Tree.CompUnit unit, TurbineTyKind enclosing) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Tree member : members) {
            if (member.kind() != Tree.Kind.TY_DECL) continue;
            Tree.TyDecl decl = (Tree.TyDecl)member;
            ClassSymbol sym = new ClassSymbol(owner.toString() + '$' + decl.name());
            toplevels.put((Object)unit, (Object)sym);
            result.put((Object)decl.name(), (Object)sym);
            ImmutableMap<String, ClassSymbol> children = Binder.bindSourceBoundClassMembers(env, sym, decl.members(), toplevels, unit, decl.tykind());
            env.putIfAbsent(sym, new SourceBoundClass(decl, owner, decl.tykind(), children, Binder.access(enclosing, decl.mods())));
        }
        return result.build();
    }

    private static SimpleEnv<ClassSymbol, PackageSourceBoundClass> bindPackages(Env<ClassSymbol, SourceBoundClass> ienv, TopLevelIndex tli, Multimap<Tree.CompUnit, ClassSymbol> classes, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        SimpleEnv.Builder<ClassSymbol, PackageSourceBoundClass> env = SimpleEnv.builder();
        Scope javaLang = (Scope)Verify.verifyNotNull((Object)tli.lookupPackage((ImmutableList<String>)ImmutableList.of((Object)"java", (Object)"lang")));
        CompoundScope topLevel = CompoundScope.base(tli).append(javaLang);
        for (Map.Entry entry : classes.asMap().entrySet()) {
            Tree.CompUnit unit = (Tree.CompUnit)entry.getKey();
            ImmutableList<String> packagename = unit.pkg().isPresent() ? ((Tree.PkgDecl)unit.pkg().get()).name() : ImmutableList.of();
            Scope packageScope = tli.lookupPackage(packagename);
            Resolve.CanonicalResolver importResolver = new Resolve.CanonicalResolver(packagename, CompoundEnv.of(ienv).append(classPathEnv));
            ImportIndex importScope = ImportIndex.create(importResolver, tli, unit.imports());
            WildImportIndex wildImportScope = WildImportIndex.create(importResolver, tli, unit.imports());
            MemberImportIndex memberImports = new MemberImportIndex(importResolver, tli, unit.imports());
            CompoundScope scope = topLevel.append(wildImportScope).append(packageScope).append(importScope);
            for (ClassSymbol sym : (Collection)entry.getValue()) {
                env.putIfAbsent(sym, new PackageSourceBoundClass(ienv.get(sym), scope, memberImports, unit.source()));
            }
        }
        return env.build();
    }

    private static Env<ClassSymbol, SourceHeaderBoundClass> bindHierarchy(Iterable<ClassSymbol> syms, final SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            completers.put((Object)sym, (Object)new LazyEnv.Completer<ClassSymbol, HeaderBoundClass, SourceHeaderBoundClass>(){

                @Override
                public SourceHeaderBoundClass complete(Env<ClassSymbol, HeaderBoundClass> henv, ClassSymbol sym) {
                    return HierarchyBinder.bind(sym, (PackageSourceBoundClass)psenv.get(sym), henv);
                }
            });
        }
        return new LazyEnv(completers.build(), classPathEnv);
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> bindTypes(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceHeaderBoundClass> shenv, Env<ClassSymbol, HeaderBoundClass> henv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.putIfAbsent(sym, TypeBinder.bind(henv, sym, shenv.get(sym)));
        }
        return builder.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> canonicalizeTypes(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.putIfAbsent(sym, CanonicalTypeBinder.bind(sym, stenv.get(sym), tenv));
        }
        return builder.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> constants(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> env, final CompoundEnv<ClassSymbol, TypeBoundClass> baseEnv) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (final ClassSymbol sym : syms) {
            final SourceTypeBoundClass info = env.get(sym);
            for (final TypeBoundClass.FieldInfo field : info.fields()) {
                if (!Binder.isConst(field)) continue;
                completers.put((Object)field.sym(), (Object)new LazyEnv.Completer<FieldSymbol, Const.Value, Const.Value>(){

                    @Override
                    public Const.Value complete(Env<FieldSymbol, Const.Value> env1, FieldSymbol k) {
                        try {
                            return new ConstEvaluator(sym, info, info.scope(), env1, baseEnv).evalFieldInitializer((Tree.Expression)field.decl().init().get(), field.type());
                        }
                        catch (LazyEnv.LazyBindingError e) {
                            return null;
                        }
                    }
                });
            }
        }
        LazyEnv constenv = new LazyEnv(completers.build(), SimpleEnv.builder().build());
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.putIfAbsent(sym, new ConstBinder(constenv, sym, baseEnv, env.get(sym)).bind());
        }
        return builder.build();
    }

    static boolean isConst(TypeBoundClass.FieldInfo field) {
        if ((field.access() & 0x10) == 0) {
            return false;
        }
        if (field.decl() == null) {
            return false;
        }
        Optional<Tree.Expression> init = field.decl().init();
        if (!init.isPresent()) {
            return false;
        }
        switch (field.type().tyKind()) {
            case PRIM_TY: {
                break;
            }
            case CLASS_TY: {
                if (((Type.ClassTy)field.type()).sym().equals(ClassSymbol.STRING)) break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> disambiguateTypeAnnotations(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.putIfAbsent(sym, DisambiguateTypeAnnotations.bind(stenv.get(sym), tenv));
        }
        return builder.build();
    }

    public static class BindingResult {
        private final ImmutableMap<ClassSymbol, SourceTypeBoundClass> units;
        private final CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv;

        public BindingResult(ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
            this.units = units;
            this.classPathEnv = classPathEnv;
        }

        public ImmutableMap<ClassSymbol, SourceTypeBoundClass> units() {
            return this.units;
        }

        public CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv() {
            return this.classPathEnv;
        }
    }
}

