/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.TimeZone;
import java.util.regex.Pattern;

@BugPattern(name="InvalidTimeZoneID", summary="Invalid time zone identifier. TimeZone.getTimeZone(String) will silently return GMT instead of the time zone you intended.", explanation="TimeZone.getTimeZone(String) silently returns GMT when an invalid time zone identifier is passed in.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class InvalidTimeZoneID
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> AVAILABLE_IDS = ImmutableSet.copyOf((Object[])TimeZone.getAvailableIDs());
    private static final Matcher<ExpressionTree> METHOD_MATCHER = Matchers.methodInvocation((Matcher)MethodMatchers.staticMethod().onClass("java.util.TimeZone").withSignature("getTimeZone(java.lang.String)"));
    private static final String HOURS_PATTERN = "([0-9]|[0-1][0-9]|2[0-3])";
    private static final String MINUTES_PATTERN = "(?:[0-5][0-9])?";
    private static final Pattern CUSTOM_ID_PATTERN = Pattern.compile("GMT[+\\-]([0-9]|[0-1][0-9]|2[0-3]):?(?:[0-5][0-9])?");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String value = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0));
        if (value == null) {
            return Description.NO_MATCH;
        }
        if (InvalidTimeZoneID.isValidID(value)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree);
        String spacesToUnderscores = value.replace(' ', '_');
        if (InvalidTimeZoneID.isValidID(spacesToUnderscores)) {
            builder.addFix((Fix)SuggestedFix.replace((Tree)tree.getArguments().get(0), (String)String.format("\"%s\"", spacesToUnderscores)));
        }
        return builder.build();
    }

    private static boolean isValidID(String value) {
        if (AVAILABLE_IDS.contains((Object)value)) {
            return true;
        }
        return CUSTOM_ID_PATTERN.matcher(value).matches();
    }
}

