/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="UnnecessaryDefaultInEnumSwitch", summary="Switch handles all enum values; an explicit default case is unnecessary and defeats error checking for non-exhaustive switches.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryDefaultInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        SuggestedFix fix;
        Symbol.TypeSymbol switchType = ((JCTree.JCSwitch)tree).getExpression().type.tsym;
        if (switchType.getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        Optional<CaseTree> maybeDefaultCase = tree.getCases().stream().filter(c -> c.getExpression() == null).findFirst();
        if (!maybeDefaultCase.isPresent()) {
            return Description.NO_MATCH;
        }
        CaseTree defaultCase = maybeDefaultCase.get();
        Set handledCases = (Set)tree.getCases().stream().map(CaseTree::getExpression).filter(IdentifierTree.class::isInstance).map(p -> ((IdentifierTree)p).getName().toString()).collect(ImmutableSet.toImmutableSet());
        if (!ASTHelpers.enumValues((Symbol.TypeSymbol)switchType).equals(handledCases)) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> defaultStatements = defaultCase.getStatements();
        if (this.trivialDefault(defaultStatements)) {
            fix = SuggestedFix.delete((Tree)defaultCase);
        } else if (!Reachability.canCompleteNormally((StatementTree)tree)) {
            String defaultSource = state.getSourceCode().subSequence(((JCTree)((Object)defaultStatements.get(0))).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(defaultStatements))).toString();
            fix = SuggestedFix.builder().delete((Tree)defaultCase).postfixWith((Tree)tree, defaultSource).build();
        } else {
            return Description.NO_MATCH;
        }
        return this.describeMatch(defaultCase, (Fix)fix);
    }

    private boolean trivialDefault(List<? extends StatementTree> defaultStatements) {
        if (defaultStatements.isEmpty()) {
            return true;
        }
        return defaultStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(defaultStatements)).getKind() == Tree.Kind.BREAK;
    }
}

