Contributing to Surf
====================
This document outlines the guidelines for contributing to the project.


* [Issues](#issues)
* [Bug Reports](#bug-reports)
* [Feature Requests](#feature-requests)
* [Pull Requests](#pull-requests)


## Issues

The [issue tracker](https://github.com/headzoo/surf/issues) is
the preferred channel for [bug reports](#bug-reports), [features requests](#feature-requests)
and submitting [pull requests](#pull-requests).


## Bug Reports

A bug is a _demonstrable problem_ that is caused by the code in the repository.

Guidelines for bug reports:

1. **Use the GitHub issue search** - check if the issue has already been reported.

2. **Check if the issue has been fixed** - try to reproduce it using the latest `master` or `dev` branch
in the repository.


## Feature Requests

Feature requests are welcome. But take a moment to find out whether your idea
fits with the scope and aims of the project. It's up to *you* to make a strong
case to convince the project's developers of the merits of this feature. Please
provide as much detail and context as possible.


## Pull Requests

Code changes are made to the [`dev`](https://github.com/headzoo/surf/tree/dev) branch.
Once a milestone has been reached the branch will be merged in with `master`, and a new
version tag created. **Do not** make your changes against the `master` branch, or they
will more than likely be ignored.


**IMPORTANT**: By submitting a patch, you agree to allow the project owners to
license your work under the terms of the [MIT License](LICENSE.md).
