/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.tree.JCTree;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

abstract class AbstractJUnit4InitMethodNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JUNIT_TEST = "org.junit.Test";
    protected final JUnitMatchers.JUnit4TestClassMatcher isJUnit4TestClass = new JUnitMatchers.JUnit4TestClassMatcher();

    protected AbstractJUnit4InitMethodNotRun() {
    }

    protected abstract Matcher<MethodTree> methodMatcher();

    protected abstract String correctAnnotation();

    protected abstract List<AnnotationReplacements> annotationReplacements();

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        boolean matches = Matchers.allOf(this.methodMatcher(), Matchers.not(Matchers.hasAnnotationOnAnyOverriddenMethod(JUNIT_TEST)), Matchers.enclosingClass(this.isJUnit4TestClass)).matches(methodTree, state);
        if (!matches) {
            return Description.NO_MATCH;
        }
        for (AnnotationReplacements replacement : this.annotationReplacements()) {
            Description description = this.tryToReplaceAnnotation(methodTree, state, replacement.badAnnotation, replacement.goodAnnotation);
            if (description == null) continue;
            return description;
        }
        String correctAnnotation = this.correctAnnotation();
        String unqualifiedClassName = this.getUnqualifiedClassName(correctAnnotation);
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            String annotationClassName = ASTHelpers.getSymbol(annotationTree).getQualifiedName().toString();
            if (!annotationClassName.endsWith("." + unqualifiedClassName)) continue;
            SuggestedFix.Builder suggestedFix = SuggestedFix.builder().removeImport(annotationClassName).addImport(correctAnnotation);
            if (this.makeProtectedPublic(methodTree, state, unqualifiedClassName, suggestedFix, false) == null) {
                return this.describeMatch(annotationTree);
            }
            suggestedFix.replace(annotationTree, "@" + unqualifiedClassName);
            return this.describeMatch(annotationTree, suggestedFix.build());
        }
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder().addImport(correctAnnotation);
        Boolean bl = this.makeProtectedPublic(methodTree, state, unqualifiedClassName, suggestedFix, true);
        if (bl == null) {
            return this.describeMatch(methodTree);
        }
        if (!bl.booleanValue()) {
            suggestedFix.prefixWith(methodTree, "@" + unqualifiedClassName + "\n");
        }
        return this.describeMatch(methodTree, suggestedFix.build());
    }

    @Nullable
    private Boolean makeProtectedPublic(MethodTree methodTree, VisitorState state, String unqualifiedClassName, SuggestedFix.Builder suggestedFix, boolean addAnnotation) {
        if (Matchers.hasModifier(Modifier.PROTECTED).matches(methodTree, state)) {
            String methodSource = state.getSourceForNode((JCTree.JCMethodDecl)methodTree);
            if (methodSource == null) {
                return null;
            }
            String methodString = (addAnnotation ? "@" + unqualifiedClassName + "\n" : "") + methodSource.toString().replaceFirst("protected ", "public ");
            suggestedFix.replace(methodTree, methodString);
            return true;
        }
        return false;
    }

    private Description tryToReplaceAnnotation(MethodTree methodTree, VisitorState state, String badAnnotation, String goodAnnotation) {
        String finalName = this.getUnqualifiedClassName(goodAnnotation);
        if (Matchers.hasAnnotation(badAnnotation).matches(methodTree, state)) {
            AnnotationTree annotationTree = this.findAnnotation(methodTree, state, badAnnotation);
            return this.describeMatch(annotationTree, SuggestedFix.builder().addImport(goodAnnotation).replace(annotationTree, "@" + finalName).build());
        }
        return null;
    }

    private String getUnqualifiedClassName(String goodAnnotation) {
        return goodAnnotation.substring(goodAnnotation.lastIndexOf(".") + 1);
    }

    private AnnotationTree findAnnotation(MethodTree methodTree, VisitorState state, String annotationName) {
        AnnotationTree annotationNode = null;
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotationTree).equals(state.getSymbolFromString(annotationName))) continue;
            annotationNode = annotationTree;
        }
        return annotationNode;
    }

    protected static class AnnotationReplacements
    implements Serializable {
        private final String goodAnnotation;
        private final String badAnnotation;

        protected AnnotationReplacements(String badAnnotation, String goodAnnotation) {
            this.goodAnnotation = goodAnnotation;
            this.badAnnotation = badAnnotation;
        }
    }
}

