/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

@BugPattern(name="HashtableContains", summary="contains() is a legacy method that is equivalent to containsValue()", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class HashtableContains
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    static final Matcher<ExpressionTree> CONTAINS_MATCHER = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf(Hashtable.class.getName()).named("contains"), MethodMatchers.instanceMethod().onDescendantOf(ConcurrentHashMap.class.getName()).named("contains"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CONTAINS_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder result = this.buildDescription(tree);
        List<Type> tyargs = ASTHelpers.getReceiverType(tree).getTypeArguments();
        if (tyargs.size() == 2) {
            Types types = state.getTypes();
            Type key = ASTHelpers.getUpperBound(tyargs.get(0), types);
            Type value = ASTHelpers.getUpperBound(tyargs.get(1), types);
            Type arg = ASTHelpers.getType((Tree)Iterables.getOnlyElement(tree.getArguments()));
            boolean valueShaped = types.isAssignable(arg, value);
            boolean keyShaped = types.isAssignable(arg, key);
            if (keyShaped && !valueShaped) {
                result.addFix(this.replaceMethodName(tree, state, "containsKey"));
                result.setMessage(String.format("contains() is a legacy method that is equivalent to containsValue(), but the argument type '%s' looks like a key", key));
                return result.build();
            } else if (valueShaped && !keyShaped) {
                result.addFix(this.replaceMethodName(tree, state, "containsValue"));
                return result.build();
            } else {
                if (!valueShaped || !keyShaped) throw new AssertionError((Object)String.format("unexpected argument to contains(): key: %s, value: %s, argument: %s", key, value, arg));
                result.addFix(this.replaceMethodName(tree, state, "containsValue"));
                result.addFix(this.replaceMethodName(tree, state, "containsKey"));
                result.setMessage(String.format("contains() is a legacy method that is equivalent to containsValue(), but the argument type '%s' could be a key or a value", key));
            }
            return result.build();
        } else {
            result.addFix(this.replaceMethodName(tree, state, "containsValue"));
        }
        return result.build();
    }

    private Fix replaceMethodName(MethodInvocationTree tree, VisitorState state, String newName) {
        String source = state.getSourceForNode((JCTree)((Object)tree.getMethodSelect())).toString();
        int idx = source.lastIndexOf("contains");
        String replacement = source.substring(0, idx) + newName + source.substring(idx + "contains".length());
        Fix fix = SuggestedFix.replace(tree.getMethodSelect(), replacement);
        return fix;
    }
}

