/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.SuppressPackageLocation;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

@BugPattern(name="PackageLocation", summary="Package names should match the directory they are declared in", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE, suppressibility=BugPattern.Suppressibility.CUSTOM_ANNOTATION, customSuppressionAnnotations={SuppressPackageLocation.class}, documentSuppression=false)
public class PackageLocation
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        Path expected;
        if (tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation(tree.getPackage(), SuppressPackageLocation.class)) {
            return Description.NO_MATCH;
        }
        String packageName = tree.getPackageName().toString();
        Path directory = PackageLocation.getFilePath(tree.getSourceFile().toUri()).getParent();
        if (directory.endsWith(expected = Paths.get(packageName.replace('.', '/'), new String[0]))) {
            return Description.NO_MATCH;
        }
        String message = String.format("Expected package %s to be declared in a directory ending with %s, instead found %s", packageName, expected, directory);
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }

    @Nullable
    private static Path getFilePath(URI uri) {
        if (!uri.getScheme().equals("jar")) {
            return Paths.get(uri.getPath(), new String[0]);
        }
        try {
            return Paths.get(((JarURLConnection)uri.toURL().openConnection()).getEntryName(), new String[0]);
        }
        catch (IOException e) {
            return null;
        }
    }
}

