/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ErrorProneScanner;
import com.google.errorprone.scanner.ScannerSupplier;
import java.util.Map;
import java.util.Set;
import org.pcollections.PMap;

class ScannerSupplierImpl
extends ScannerSupplier {
    private final ImmutableBiMap<String, BugCheckerInfo> checks;
    private final PMap<String, BugPattern.SeverityLevel> severities;
    private static final Function<BugCheckerInfo, BugChecker> INSTANTIATE_CHECKER = new Function<BugCheckerInfo, BugChecker>(){

        public BugChecker apply(BugCheckerInfo checkerClass) {
            try {
                return checkerClass.checkerClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new LinkageError("Could not instantiate BugChecker.", e);
            }
        }
    };
    private final Predicate<BugCheckerInfo> isCheckEnabled = new Predicate<BugCheckerInfo>(){

        public boolean apply(BugCheckerInfo input) {
            return input.severity((Map<String, BugPattern.SeverityLevel>)ScannerSupplierImpl.this.severities).enabled();
        }
    };

    ScannerSupplierImpl(ImmutableBiMap<String, BugCheckerInfo> checks, PMap<String, BugPattern.SeverityLevel> severities) {
        Preconditions.checkArgument((boolean)Sets.difference((Set)severities.keySet(), (Set)checks.keySet()).isEmpty(), (Object)"enabledChecks must be a subset of allChecks");
        this.checks = checks;
        this.severities = severities;
    }

    public ErrorProneScanner get() {
        return new ErrorProneScanner(Iterables.transform(this.getEnabledChecks(), INSTANTIATE_CHECKER), (Map<String, BugPattern.SeverityLevel>)this.severities);
    }

    @Override
    protected ImmutableBiMap<String, BugCheckerInfo> getAllChecks() {
        return this.checks;
    }

    @Override
    protected PMap<String, BugPattern.SeverityLevel> severities() {
        return this.severities;
    }

    @Override
    protected ImmutableSet<BugCheckerInfo> getEnabledChecks() {
        return FluentIterable.from((Iterable)this.getAllChecks().values()).filter(this.isCheckEnabled).toSet();
    }
}

