---
layout: posts
title: Bazel 0.3.0 Released
---

We are delighted to announce the
[0.3.0 release](https://github.com/bazelbuild/bazel/releases/tag/0.3.0) of
Bazel. This milestone is marked by support for IDE integration but also major
features such as remote caching of build artifacts and experimental Windows
support.

## Improvements from our [roadmap](http://bazel.io/roadmap.html)

### IDE support

In this release, we made it possible to [generate information for IDEs from
Bazel build files](http://bazel.io/blog/2016/06/10/ide-support.html) using
[Skylark aspects](http://bazel.io/docs/skylark/aspects.html).

Simultaneous with Bazel 0.3 release, we are announcing the availability of two
projects integrating Bazel with different IDEs:

* [Tulsi](http://tulsi.bazel.io) is an Xcode plugin for Bazel. This is the same
  plugin that teams inside Google use for developing iOS applications.
* [e4b](https://github.com/bazelbuild/e4b) is an experimental Eclipse plugin for
  Bazel. It was made to illustrate the use of Skylark aspects for IDE
  integration. This is an experimental plugin but we welcome any contributions
  to it.

### Windows support

Bazel can now bootstrap on [Windows](http://bazel.io/docs/windows.html) without
admin privilege and can use the Microsoft Visual C++ toolchain. Windows
support is still highly experimental and we have identified
[several issues](https://github.com/bazelbuild/bazel/issues?q=is%3Aopen+is%3Aissue+label%3A%22category%3A+windows%22)
and their solutions. We are dedicated to a good native experience on Windows.

### Remote caching of distributed artifacts

[Alpha Lam](https://github.com/hhclam) has contributed experimental support
for [distributed caching](https://github.com/bazelbuild/bazel/commit/79adf59)
and [execution](https://github.com/bazelbuild/bazel/commit/a1a79cb). This is
an ongoing area of development and several engineers from Google are working
with Alpha to enhance that support.

### Skylark remote repositories

Remote repository rules can now be created using
[Skylark](http://bazel.io/docs/skylark/repository_rules.html). This can be used
to support your custom protocols, interfacing with new packaging systems or even
do auto-configuration to use a toolchain on your local disk. We use it
especially to have [a better out-of-the-box experience with C++ toolchains](http://www.bazel.io/blog/2016/03/31/autoconfiguration.html).

## Other major changes since 0.2.0

* We just open-sourced our BUILD file formatter, [buildifier](https://github.com/bazelbuild/buildifier).
* We now provide a Debian APT repository for installing bazel, see the
  [installation guide](http://bazel.io/docs/install.html) on how to use it.
* Our JUnit test runner for Java tests (`--nolegacy_bazel_java_test`) is now the
  default.

For changes since 0.2.3 (the minor version before 0.3.0), see the
[release notes](https://github.com/bazelbuild/bazel/releases/tag/0.3.0) for
changes.

## Future plans

Looking ahead to 0.4.0:

* The last blockers for `--strategy=worker=Javac` will be resolved, making Java
  builds [faster](http://www.bazel.io/blog/2015/12/10/java-workers.html).
* [Yue](https://github.com/hermione521) has made great progress in making
  [Ulf](https://github.com/ulfjack)'s prototype of [sandboxing for OS
  X](https://github.com/bazelbuild/bazel/tree/osx-sandbox-hardlinks) real.

## Finally...

A big thank you to our community for your continued support. Particular
shout-outs to the following contributors:

* [Justine Tunney](https://github.com/jart) - for developping and maintaining
  the [Closure JS rules](https://github.com/bazelbuild/rules_closure) of Bazel.
* [Alpha Lam](https://github.com/hhclam) - for implementing remote
  caching/execution and following up on these features.
* [David Chen](https://github.com/davidzchen) - for going above and beyond, far
  more than a standard 20% contribution: improving our documentation,
  creating the [Skylark documentation generator](https://github.com/bazelbuild/skydoc),
  fixing bugs and contributing features in Bazel and helping out TensorFlow with
  their use of Bazel.

Thank you all, keep the discussion and bug reports coming!
