/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.OptionParser;
import com.googlecode.jslint4java.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLint {
    private final Map<Option, Object> options = new EnumMap<Option, Object>(Option.class);
    private final Scriptable scope;

    public JSLint(Scriptable scope) {
        this.scope = scope;
    }

    public void addOption(Option o) {
        this.options.put(o, Boolean.TRUE);
    }

    public void addOption(Option o, String arg) {
        OptionParser optionParser = new OptionParser();
        this.options.put(o, optionParser.parse(o.getType(), arg));
    }

    private void doLint(String javaScript) {
        String src = javaScript == null ? "" : javaScript;
        Object[] args = new Object[]{src, this.optionsAsJavaScriptObject()};
        Function lintFunc = (Function)this.scope.get("JSLINT", this.scope);
        lintFunc.call(Context.getCurrentContext(), this.scope, this.scope, args);
    }

    public String getEdition() {
        Scriptable lintScope = (Scriptable)this.scope.get("JSLINT", this.scope);
        return (String)lintScope.get("edition", lintScope);
    }

    public List<Issue> lint(String systemId, Reader reader) throws IOException {
        return this.lint(systemId, Util.readerToString(reader));
    }

    public List<Issue> lint(String systemId, String javaScript) {
        this.doLint(javaScript);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        this.readErrors(systemId, issues);
        return issues;
    }

    private Scriptable optionsAsJavaScriptObject() {
        Scriptable opts = Context.getCurrentContext().newObject(this.scope);
        for (Map.Entry<Option, Object> entry : this.options.entrySet()) {
            String key = entry.getKey().getLowerName();
            Object value = Context.javaToJS(entry.getValue(), opts);
            opts.put(key, opts, value);
        }
        return opts;
    }

    private void readErrors(String systemId, List<Issue> issues) {
        Scriptable JSLINT = (Scriptable)this.scope.get("JSLINT", this.scope);
        Scriptable errors = (Scriptable)JSLINT.get("errors", JSLINT);
        int count = Util.intValue("length", errors);
        for (int i = 0; i < count; ++i) {
            Scriptable err = (Scriptable)errors.get(i, errors);
            if (err == null) continue;
            issues.add(Issue.IssueBuilder.fromJavaScript(systemId, err));
        }
    }

    public String report(String javaScript) {
        return this.report(javaScript, false);
    }

    public String report(String javaScript, boolean errorsOnly) {
        this.doLint(javaScript);
        Object[] args = new Object[]{errorsOnly};
        Scriptable lintScope = (Scriptable)this.scope.get("JSLINT", this.scope);
        Function reportFunc = (Function)lintScope.get("report", lintScope);
        return (String)reportFunc.call(Context.getCurrentContext(), this.scope, this.scope, args);
    }

    public void resetOptions() {
        this.options.clear();
    }
}

