/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.JSLint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptableObject;

public class JSLintBuilder {
    private static final String JSLINT_FILE = "com/googlecode/jslint4java/fulljslint.js";
    private static final ContextFactory contextFactory = new ContextFactory();
    private final ScriptableObject scope;
    private final Context ctx = contextFactory.enterContext();

    public JSLintBuilder() {
        this.scope = this.ctx.initStandardObjects();
    }

    public JSLint create() {
        return new JSLint(this.scope);
    }

    public JSLint fromClasspathResource(String resource) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource)));
        return this.fromReader(reader, resource);
    }

    public JSLint fromDefault() throws IOException {
        return this.fromClasspathResource(JSLINT_FILE);
    }

    public JSLint fromFile(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        return this.fromReader(reader, f.toString());
    }

    public JSLint fromReader(Reader reader, String name) throws IOException {
        this.ctx.evaluateReader(this.scope, reader, name, 1, null);
        return new JSLint(this.scope);
    }
}

