/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.ant.PlainResultFormatter;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.ant.XmlResultFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;

public class FormatterElement {
    private Type type;
    private OutputStream defaultOutputStream = System.out;
    private File destFile;

    private OutputStream getFileOutputStream() {
        try {
            return new FileOutputStream(this.destFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException(e);
        }
    }

    public ResultFormatter getResultFormatter() {
        if (this.type == null) {
            throw new BuildException("you must specify type");
        }
        ResultFormatter rf = this.type.getResultFormatter();
        if (this.destFile != null) {
            rf.setOut(this.getFileOutputStream());
        } else {
            rf.setOut(this.defaultOutputStream);
        }
        return rf;
    }

    void setDefaultOutputStream(OutputStream defaultOutputStream) {
        this.defaultOutputStream = defaultOutputStream;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setType(Type type) {
        this.type = type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        plain{

            public ResultFormatter getResultFormatter() {
                return new PlainResultFormatter();
            }
        }
        ,
        xml{

            public ResultFormatter getResultFormatter() {
                return new XmlResultFormatter();
            }
        };


        abstract ResultFormatter getResultFormatter();
    }
}

