/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.ant.ResultFormatter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainResultFormatter
implements ResultFormatter {
    protected OutputStream out;
    protected PrintWriter w = null;

    @Override
    public void begin() {
        this.w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.out)));
    }

    @Override
    public void end() {
        FileUtils.close(this.w);
        this.w = null;
    }

    @Override
    public void output(String name, List<Issue> issues) {
        if (issues.size() == 0) {
            return;
        }
        for (Issue issue : issues) {
            this.outputOneIssue(issue);
        }
    }

    private void outputOneIssue(Issue issue) {
        String msg = issue.getSystemId() + ":" + issue.getLine() + ":" + issue.getCharacter() + ": " + issue.getReason();
        this.w.println(msg);
        String evidence = issue.getEvidence();
        if (evidence != null && !"".equals(evidence)) {
            this.w.println(evidence);
            this.w.println(this.spaces(issue.getCharacter() - 1) + "^");
        }
    }

    @Override
    public void setOut(OutputStream os) {
        this.out = os;
    }

    protected String spaces(int howmany) {
        StringBuffer sb = new StringBuffer(howmany);
        for (int i = 0; i < howmany; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

