/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ant.antunit.AntUnitListener;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;

public class AntUnit
extends Task {
    public static final String ERROR_TESTS_FAILED = "Tests failed with ";
    public static final String ERROR_NO_TESTS = "You must specify build files to test.";
    public static final String ERROR_NON_FILES = "Only file system resources are supported.";
    private static final String SETUP = "setUp";
    private static final String TEST = "test";
    private static final String TEARDOWN = "tearDown";
    private static final String SUITESETUP = "suiteSetUp";
    private static final String SUITETEARDOWN = "suiteTearDown";
    private Union buildFiles;
    private Project newProject;
    private ArrayList listeners = new ArrayList();
    private ArrayList propertySets = new ArrayList();
    private int failures = 0;
    private int errors = 0;
    private boolean failOnError = true;
    private String errorProperty = null;

    public void add(ResourceCollection rc) {
        if (this.buildFiles == null) {
            this.buildFiles = new Union();
        }
        this.buildFiles.add(rc);
    }

    public void add(AntUnitListener al) {
        this.listeners.add(al);
        al.setParentTask(this);
    }

    public void addPropertySet(PropertySet ps) {
        this.propertySets.add(ps);
    }

    public void setErrorProperty(String s) {
        this.errorProperty = s;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() {
        if (this.buildFiles == null) {
            throw new BuildException(ERROR_NO_TESTS);
        }
        this.doResourceCollection(this.buildFiles);
        if (this.failures > 0 || this.errors > 0) {
            if (this.errorProperty != null) {
                this.getProject().setNewProperty(this.errorProperty, "true");
            }
            if (this.failOnError) {
                throw new BuildException(ERROR_TESTS_FAILED + this.failures + " failure" + (this.failures != 1 ? "s" : "") + " and " + this.errors + " error" + (this.errors != 1 ? "s" : ""));
            }
        }
    }

    private void doResourceCollection(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException(ERROR_NON_FILES);
        }
        Iterator i = rc.iterator();
        while (i.hasNext()) {
            FileResource r = (FileResource)i.next();
            if (r.isExists()) {
                this.doFile(r.getFile());
                continue;
            }
            this.log("Skipping " + r + " since it doesn't exist", 3);
        }
    }

    /*
     * Exception decompiling
     */
    private void doFile(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 60[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void handleOutput(String outputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(outputToHandle, false);
        } else {
            super.handleOutput(outputToHandle);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String toFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(toFlush, false);
        } else {
            super.handleFlush(toFlush);
        }
    }

    public void handleErrorOutput(String errorOutputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(errorOutputToHandle, true);
        } else {
            super.handleErrorOutput(errorOutputToHandle);
        }
    }

    public void handleErrorFlush(String errorOutputToFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(errorOutputToFlush, true);
        } else {
            super.handleErrorFlush(errorOutputToFlush);
        }
    }

    private Project createProjectForFile(File f) {
        Project p = new Project();
        p.setDefaultInputStream(this.getProject().getDefaultInputStream());
        p.initProperties();
        p.setInputHandler(this.getProject().getInputHandler());
        this.getProject().initSubProject(p);
        Iterator outer = this.propertySets.iterator();
        while (outer.hasNext()) {
            PropertySet set = (PropertySet)outer.next();
            Properties props = set.getProperties();
            Iterator keys = props.keySet().iterator();
            while (keys.hasNext()) {
                Object value;
                String key = keys.next().toString();
                if ("basedir".equals(key) || "ant.file".equals(key) || (value = props.get(key)) == null || !(value instanceof String) || p.getProperty(key) != null) continue;
                p.setNewProperty(key, (String)value);
            }
        }
        p.setUserProperty("ant.file", f.getAbsolutePath());
        this.attachListeners(f, p);
        ProjectHelper.configureProject(p, f);
        return p;
    }

    private void attachListeners(File buildFile, Project p) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            p.addBuildListener(new BuildToAntUnitListener(buildFile.getAbsolutePath(), al));
            al.setCurrentTestProject(p);
        }
    }

    private void fireStartTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.startTest(targetName);
        }
    }

    private void fireFail(String targetName, AssertionFailedException ae) {
        ++this.failures;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addFailure(targetName, ae);
        }
    }

    private void fireError(String targetName, Throwable t) {
        ++this.errors;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addError(targetName, t);
        }
    }

    private void fireEndTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.endTest(targetName);
        }
    }

    private class BuildToAntUnitListener
    implements BuildListener {
        private String buildFile;
        private AntUnitListener a;

        BuildToAntUnitListener(String buildFile, AntUnitListener a) {
            this.buildFile = buildFile;
            this.a = a;
        }

        public void buildStarted(BuildEvent event) {
            this.a.startTestSuite(event.getProject(), this.buildFile);
        }

        public void buildFinished(BuildEvent event) {
            this.a.endTestSuite(event.getProject(), this.buildFile);
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }
    }
}

