/*
 * Decompiled with CFR 0.152.
 */
package extdoc;

import extdoc.jsdoc.processor.FileProcessor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main {
    private static Options options = null;

    private static void wrongCli(String msg) {
        System.err.println("Wrong command line arguments: " + msg);
        Main.showHelp();
    }

    private static void showHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar ext-doc.jar [-p project] -o output [-s source1 -s source2 ...]", options);
    }

    public static void main(String[] args) {
        options = new Options();
        Option quiet = new Option("q", "quiet", false, "be extra quiet");
        Option verbose = new Option("v", "verbose", false, "be extra verbose");
        OptionBuilder.withArgName("project");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Project XML file.");
        OptionBuilder.withLongOpt("project");
        Option project = OptionBuilder.create('p');
        OptionBuilder.withArgName("output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Directory where documentation should be created.");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output");
        Option output = OptionBuilder.create('o');
        OptionBuilder.withArgName("template");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("XML File containing template informaiton");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("template");
        Option template = OptionBuilder.create('t');
        OptionBuilder.withArgName("source");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Source files");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withLongOpt("source");
        Option source = OptionBuilder.create('s');
        options.addOption(quiet);
        options.addOption(verbose);
        options.addOption(project);
        options.addOption(output);
        options.addOption(template);
        options.addOption(source);
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("project") || cmd.hasOption("source")) {
                FileProcessor processor = new FileProcessor();
                if (cmd.hasOption("quiet")) {
                    processor.setQuiet();
                } else if (cmd.hasOption("verbose")) {
                    processor.setVerbose();
                }
                processor.process(cmd.getOptionValue("project"), cmd.getOptionValues("source"));
                processor.saveToFolder(cmd.getOptionValue("output"), cmd.getOptionValue("template"));
            } else {
                Main.wrongCli("Project XML file or source files should be specified");
            }
        }
        catch (ParseException e) {
            Main.wrongCli(e.getMessage());
        }
    }
}

