/*
 * Decompiled with CFR 0.152.
 */
package extdoc.jsdoc.processor;

import extdoc.jsdoc.docs.DocCfg;
import extdoc.jsdoc.docs.DocClass;
import extdoc.jsdoc.docs.DocEvent;
import extdoc.jsdoc.docs.DocMethod;
import extdoc.jsdoc.docs.DocProperty;
import extdoc.jsdoc.processor.DocFile;
import extdoc.jsdoc.schema.Tag;
import extdoc.jsdoc.tree.TreePackage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class Context {
    private static final String TARGET_FILE_EXTENSION = "html";
    long position = 0L;
    long lastCommentPosition = 0L;
    private DocClass currentClass = null;
    private DocFile currentFile = null;
    private List<DocFile> docFiles = new ArrayList<DocFile>();
    private List<DocClass> classes = new ArrayList<DocClass>();
    private List<DocCfg> cfgs = new ArrayList<DocCfg>();
    private List<DocProperty> properties = new ArrayList<DocProperty>();
    private List<DocMethod> methods = new ArrayList<DocMethod>();
    private List<DocEvent> events = new ArrayList<DocEvent>();
    private TreePackage tree = new TreePackage();
    private List<Tag> customTags = new ArrayList<Tag>();

    Context() {
    }

    public List<DocFile> getDocFiles() {
        return this.docFiles;
    }

    public List<DocClass> getClasses() {
        return this.classes;
    }

    public List<DocCfg> getCfgs() {
        return this.cfgs;
    }

    public List<DocProperty> getProperties() {
        return this.properties;
    }

    public List<DocMethod> getMethods() {
        return this.methods;
    }

    public List<DocEvent> getEvents() {
        return this.events;
    }

    public TreePackage getTree() {
        return this.tree;
    }

    public List<Tag> getCustomTags() {
        return this.customTags;
    }

    public void addDocFile(DocFile docFile) {
        this.docFiles.add(docFile);
    }

    public void addDocClass(DocClass docClass) {
        docClass.positionInFile = this.lastCommentPosition;
        docClass.id = "cls-" + docClass.className;
        docClass.href = this.currentFile.targetFileName + '#' + docClass.id;
        this.currentFile.docs.add(docClass);
        this.currentClass = docClass;
        this.classes.add(docClass);
    }

    public void addDocCfg(DocCfg docCfg) {
        docCfg.positionInFile = this.lastCommentPosition;
        docCfg.id = "cfg-" + docCfg.className + '-' + docCfg.name;
        docCfg.href = this.currentFile.targetFileName + '#' + docCfg.id;
        this.currentFile.docs.add(docCfg);
        this.cfgs.add(docCfg);
    }

    public void addDocProperty(DocProperty docProperty) {
        docProperty.positionInFile = this.lastCommentPosition;
        docProperty.id = "prop-" + docProperty.className + '-' + docProperty.name;
        docProperty.href = this.currentFile.targetFileName + '#' + docProperty.id;
        this.currentFile.docs.add(docProperty);
        this.properties.add(docProperty);
    }

    public void addDocMethod(DocMethod docMethod) {
        docMethod.positionInFile = this.lastCommentPosition;
        docMethod.id = "method-" + docMethod.className + '-' + docMethod.name;
        docMethod.href = this.currentFile.targetFileName + '#' + docMethod.id;
        for (DocMethod method : this.methods) {
            if (!method.id.equals(docMethod.id)) continue;
            this.methods.remove(method);
            this.currentFile.docs.remove(method);
            break;
        }
        this.currentFile.docs.add(docMethod);
        this.methods.add(docMethod);
    }

    public void addDocEvent(DocEvent docEvent) {
        docEvent.positionInFile = this.lastCommentPosition;
        docEvent.id = "event-" + docEvent.className + '-' + docEvent.name;
        docEvent.href = this.currentFile.targetFileName + '#' + docEvent.id;
        this.currentFile.docs.add(docEvent);
        this.events.add(docEvent);
    }

    public void addClassToTree(DocClass docClass) {
        this.tree.addClass(docClass);
    }

    public void sortTree() {
        this.tree.sort();
    }

    public void setCustomTags(List<Tag> customTags) {
        this.customTags = customTags;
    }

    public void setCurrentClass(DocClass currentClass) {
        this.currentClass = currentClass;
    }

    public DocClass getCurrentClass() {
        return this.currentClass;
    }

    public DocFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File currentFile) {
        DocFile docFile = new DocFile();
        docFile.fileName = currentFile.getName();
        docFile.file = currentFile;
        int sameNameCount = 0;
        for (DocFile f : this.docFiles) {
            if (!f.fileName.equals(docFile.fileName)) continue;
            ++sameNameCount;
        }
        int lastDot = docFile.fileName.lastIndexOf(46);
        String name = lastDot != -1 ? docFile.fileName.substring(0, lastDot) : docFile.fileName;
        docFile.targetFileName = sameNameCount > 0 ? name + sameNameCount + '.' + TARGET_FILE_EXTENSION : name + '.' + TARGET_FILE_EXTENSION;
        this.currentFile = docFile;
        this.addDocFile(this.currentFile);
    }
}

