/*
 * Decompiled with CFR 0.152.
 */
package extdoc.jsdoc.processor;

import extdoc.jsdoc.docs.ClassDescr;
import extdoc.jsdoc.docs.Description;
import extdoc.jsdoc.docs.Doc;
import extdoc.jsdoc.docs.DocAttribute;
import extdoc.jsdoc.docs.DocCfg;
import extdoc.jsdoc.docs.DocClass;
import extdoc.jsdoc.docs.DocCustomTag;
import extdoc.jsdoc.docs.DocEvent;
import extdoc.jsdoc.docs.DocMethod;
import extdoc.jsdoc.docs.DocProperty;
import extdoc.jsdoc.docs.Param;
import extdoc.jsdoc.processor.Context;
import extdoc.jsdoc.processor.DocFile;
import extdoc.jsdoc.schema.Source;
import extdoc.jsdoc.schema.Sources;
import extdoc.jsdoc.schema.Tag;
import extdoc.jsdoc.schema.Tags;
import extdoc.jsdoc.tags.CfgTag;
import extdoc.jsdoc.tags.ClassTag;
import extdoc.jsdoc.tags.EventTag;
import extdoc.jsdoc.tags.ExtendsTag;
import extdoc.jsdoc.tags.MemberTag;
import extdoc.jsdoc.tags.ParamTag;
import extdoc.jsdoc.tags.PropertyTag;
import extdoc.jsdoc.tags.ReturnTag;
import extdoc.jsdoc.tags.TypeTag;
import extdoc.jsdoc.tags.impl.Comment;
import extdoc.jsdoc.tplschema.ClassTemplate;
import extdoc.jsdoc.tplschema.Copy;
import extdoc.jsdoc.tplschema.Resources;
import extdoc.jsdoc.tplschema.Template;
import extdoc.jsdoc.tplschema.TreeTemplate;
import extdoc.jsdoc.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileProcessor {
    private final Logger logger;
    private final Handler logHandler;
    private Context context = new Context();
    private static final String OUT_FILE_EXTENSION = "html";
    private static final boolean GENERATE_DEBUG_XML = false;
    private static final String COMPONENT_NAME = "Ext.Component";
    private static final String DEFAULT_TYPE = "Object";
    private static final String START_LINK = "{@link";
    private static final String MEMBER_REFERENCE_TPL = "<a href=\"output/{0}.html#{0}-{1}\" ext:member=\"{1}\" ext:cls=\"{0}\">{2}</a>";
    private static final String CLASS_REFERENCE_TPL = "<a href=\"output/{0}.html\" ext:cls=\"{0}\">{1}</a>";
    private static final int DESCR_MAX_LENGTH = 117;
    private static final String DEFAULT_MATCH = "*.js";
    private static final boolean DEFAULT_SKIPHIDDEN = true;
    private static final String ENCODING = "UTF8";
    private static final String START_COMMENT = "/**";
    private static final String END_COMMENT = "*/";
    private Pattern filePattern = Pattern.compile(StringUtils.wildcardToRegex("*.js"));
    private boolean skipHidden = true;
    private static final String WRAPPER_CODE_MARKER = "###SOURCE###";

    public FileProcessor() {
        this.logger = Logger.getLogger("extdoc.jsdoc.processor");
        this.logger.setUseParentHandlers(false);
        this.logHandler = new ConsoleHandler();
        this.logHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
        this.logger.addHandler(this.logHandler);
    }

    public void setVerbose() {
        this.logger.setLevel(Level.FINE);
        this.logHandler.setLevel(Level.FINE);
    }

    public void setQuiet() {
        this.logger.setLevel(Level.OFF);
    }

    private String[] processLink(String text) {
        String shortText;
        String longText;
        StringUtils.ClsAttrName res = StringUtils.processLink(text);
        if (res.attr.isEmpty()) {
            String cls = res.cls;
            String name = res.name.isEmpty() ? res.cls : res.name;
            longText = MessageFormat.format(CLASS_REFERENCE_TPL, cls, name);
            shortText = name;
        } else {
            String cls = res.cls.isEmpty() ? this.context.getCurrentClass().className : res.cls;
            String attr = res.attr;
            String name = res.name.isEmpty() ? (res.cls.isEmpty() ? res.attr : cls + '.' + res.attr) : res.name;
            longText = MessageFormat.format(MEMBER_REFERENCE_TPL, cls, attr, name);
            shortText = name;
        }
        return new String[]{longText, shortText};
    }

    private Description inlineLinks(String content) {
        return this.inlineLinks(content, false);
    }

    private Description inlineLinks(String cnt, boolean alwaysGenerateShort) {
        if (cnt == null) {
            return null;
        }
        String content = StringUtils.highlightCode(cnt);
        LinkStates state = LinkStates.READ;
        StringBuilder sbHtml = new StringBuilder();
        StringBuilder sbText = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            switch (state) {
                case READ: {
                    if (StringUtils.endsWith(buffer, START_LINK)) {
                        String substr = buffer.substring(0, buffer.length() - START_LINK.length());
                        sbHtml.append(substr);
                        sbText.append(substr);
                        buffer.setLength(0);
                        state = LinkStates.LINK;
                        continue block4;
                    }
                    buffer.append(ch);
                    continue block4;
                }
                case LINK: {
                    if (ch == '}') {
                        String[] str = this.processLink(buffer.toString());
                        sbHtml.append(str[0]);
                        sbText.append(str[1]);
                        buffer.setLength(0);
                        state = LinkStates.READ;
                        continue block4;
                    }
                    buffer.append(ch);
                }
            }
        }
        sbHtml.append((CharSequence)buffer);
        sbText.append((CharSequence)buffer);
        String sbString = sbText.toString().replaceAll("<\\S*?>", "");
        Description description = new Description();
        description.longDescr = sbHtml.toString();
        if (alwaysGenerateShort) {
            description.hasShort = true;
            description.shortDescr = sbString.length() > 117 ? sbString.substring(0, 117) + "..." : sbString;
        } else {
            description.hasShort = sbString.length() > 117;
            description.shortDescr = description.hasShort ? sbString.substring(0, 117) + "..." : null;
        }
        return description;
    }

    private void readParams(List<ParamTag> paramTags, List<Param> params) {
        for (ParamTag paramTag : paramTags) {
            Param param = new Param();
            param.name = paramTag.getParamName();
            param.type = paramTag.getParamType();
            Description descr = this.inlineLinks(paramTag.getParamDescription());
            param.description = descr != null ? descr.longDescr : null;
            param.optional = paramTag.isOptional();
            params.add(param);
        }
    }

    private void injectCustomTags(Doc doc, Comment comment) {
        for (Tag customTag : this.context.getCustomTags()) {
            Object tag = comment.tag('@' + customTag.getName());
            if (tag == null) continue;
            DocCustomTag t = new DocCustomTag();
            String title = customTag.getTitle();
            String format = customTag.getFormat();
            t.title = title;
            t.value = format != null ? MessageFormat.format(format, tag.text()) : tag.text();
            doc.customTags.add(t);
        }
    }

    private void processClass(Comment comment) {
        DocClass cls = new DocClass();
        ClassTag classTag = (ClassTag)comment.tag("@class");
        Object singletonTag = comment.tag("@singleton");
        ExtendsTag extendsTag = (ExtendsTag)comment.tag("@extends");
        Object constructorTag = comment.tag("@constructor");
        List<ParamTag> paramTags = comment.tags("@param");
        Object namespaceTag = comment.tag("@namespace");
        cls.className = classTag.getClassName();
        boolean found = false;
        for (DocClass d : this.context.getClasses()) {
            if (!d.className.equals(cls.className)) continue;
            this.context.setCurrentClass(d);
            cls = d;
            found = true;
            break;
        }
        if (!found) {
            this.context.addDocClass(cls);
        }
        if (cls.packageName == null) {
            if (namespaceTag != null) {
                cls.packageName = namespaceTag.text();
                cls.shortClassName = StringUtils.separateByLastDot(cls.className)[1];
            } else {
                String[] str = StringUtils.separatePackage(cls.className);
                cls.packageName = str[0];
                cls.shortClassName = str[1];
            }
        }
        cls.definedIn.add(this.context.getCurrentFile().fileName);
        if (!cls.singleton) {
            boolean bl = cls.singleton = singletonTag != null;
        }
        if (cls.parentClass == null) {
            String string = cls.parentClass = extendsTag != null ? extendsTag.getClassName() : null;
        }
        if (comment.hasTag("@private") || comment.hasTag("@ignore")) {
            cls.hide = true;
        }
        if (!cls.hasConstructor) {
            boolean bl = cls.hasConstructor = constructorTag != null;
            if (constructorTag != null) {
                cls.constructorDescription = this.inlineLinks(constructorTag.text(), true);
                this.readParams(paramTags, cls.params);
            }
        }
        if (cls.description == null) {
            Description descr;
            String description = classTag.getClassDescription();
            if (description == null && extendsTag != null) {
                description = extendsTag.getClassDescription();
            }
            cls.description = (descr = this.inlineLinks(description)) != null ? descr.longDescr : null;
        }
        List innerCfgs = comment.tags("@cfg");
        for (CfgTag innerCfg : innerCfgs) {
            DocCfg cfg = this.getDocCfg(innerCfg);
            this.context.addDocCfg(cfg);
        }
    }

    private DocCfg getDocCfg(CfgTag tag) {
        DocCfg cfg = new DocCfg();
        cfg.name = tag.getCfgName();
        cfg.type = tag.getCfgType();
        cfg.description = this.inlineLinks(tag.getCfgDescription());
        cfg.optional = tag.isOptional();
        cfg.className = this.context.getCurrentClass().className;
        cfg.shortClassName = this.context.getCurrentClass().shortClassName;
        return cfg;
    }

    private void processCfg(Comment comment) {
        if (comment.hasTag("@private") || comment.hasTag("@ignore")) {
            return;
        }
        CfgTag tag = (CfgTag)comment.tag("@cfg");
        DocCfg cfg = this.getDocCfg(tag);
        cfg.hide = comment.tag("@hide") != null;
        this.injectCustomTags(cfg, comment);
        this.context.addDocCfg(cfg);
    }

    private void processProperty(Comment comment, String extraLine) {
        if (comment.hasTag("@private") || comment.hasTag("@ignore")) {
            return;
        }
        DocProperty property = new DocProperty();
        PropertyTag propertyTag = (PropertyTag)comment.tag("@property");
        TypeTag typeTag = (TypeTag)comment.tag("@type");
        property.name = StringUtils.separateByLastDot(extraLine)[1];
        String description = comment.getDescription();
        if (propertyTag != null) {
            String propertyDescription;
            String propertyName = propertyTag.getPropertyName();
            if (propertyName != null && propertyName.length() > 0) {
                property.name = propertyName;
            }
            if ((propertyDescription = propertyTag.getPropertyDescription()) != null && propertyDescription.length() > 0) {
                description = propertyDescription;
            }
        }
        property.type = typeTag != null ? typeTag.getType() : DEFAULT_TYPE;
        property.description = this.inlineLinks(description);
        property.className = this.context.getCurrentClass().className;
        property.shortClassName = this.context.getCurrentClass().shortClassName;
        property.hide = comment.tag("@hide") != null;
        this.injectCustomTags(property, comment);
        this.context.addDocProperty(property);
    }

    private void processMethod(Comment comment, String extraLine) {
        if (comment.hasTag("@private") || comment.hasTag("@ignore")) {
            return;
        }
        DocMethod method = new DocMethod();
        Object methodTag = comment.tag("@method");
        Object staticTag = comment.tag("@static");
        List<ParamTag> paramTags = comment.tags("@param");
        ReturnTag returnTag = (ReturnTag)comment.tag("@return");
        MemberTag memberTag = (MemberTag)comment.tag("@member");
        DocClass doc = this.context.getCurrentClass();
        method.className = doc != null ? doc.className : null;
        method.shortClassName = doc != null ? doc.shortClassName : null;
        method.name = StringUtils.separatePackage(extraLine)[1];
        if (methodTag != null && !methodTag.text().isEmpty()) {
            method.name = methodTag.text();
        }
        if (memberTag != null) {
            String name = memberTag.getMethodName();
            if (name != null) {
                method.name = name;
            }
            method.className = memberTag.getClassName();
            method.shortClassName = StringUtils.separatePackage(method.className)[1];
        }
        method.isStatic = staticTag != null;
        method.description = this.inlineLinks(comment.getDescription(), true);
        if (returnTag != null) {
            method.returnType = returnTag.getReturnType();
            method.returnDescription = returnTag.getReturnDescription();
        }
        this.readParams(paramTags, method.params);
        method.hide = comment.tag("@hide") != null;
        this.injectCustomTags(method, comment);
        this.context.addDocMethod(method);
    }

    private void processEvent(Comment comment) {
        if (comment.hasTag("@private") || comment.hasTag("@ignore")) {
            return;
        }
        DocEvent event = new DocEvent();
        EventTag eventTag = (EventTag)comment.tag("@event");
        List<ParamTag> paramTags = comment.tags("@param");
        event.name = eventTag.getEventName();
        event.description = this.inlineLinks(eventTag.getEventDescription(), true);
        this.readParams(paramTags, event.params);
        event.className = this.context.getCurrentClass().className;
        event.shortClassName = this.context.getCurrentClass().shortClassName;
        event.hide = comment.tag("@hide") != null;
        this.injectCustomTags(event, comment);
        this.context.addDocEvent(event);
    }

    static CommentType resolveCommentType(Comment comment) {
        return FileProcessor.resolveCommentType(comment, "", "");
    }

    static CommentType resolveCommentType(Comment comment, String extraLine, String extra2Line) {
        if (comment.hasTag("@class")) {
            return CommentType.CLASS;
        }
        if (comment.hasTag("@event")) {
            return CommentType.EVENT;
        }
        if (comment.hasTag("@cfg")) {
            return CommentType.CFG;
        }
        if (comment.hasTag("@param") || comment.hasTag("@return") || comment.hasTag("@method")) {
            return CommentType.METHOD;
        }
        if (comment.hasTag("@type") || comment.hasTag("@property")) {
            return CommentType.PROPERTY;
        }
        if (extra2Line.equals("function")) {
            return CommentType.METHOD;
        }
        return CommentType.PROPERTY;
    }

    private void processComment(String content, String extraLine, String extra2Line) {
        if (content == null) {
            return;
        }
        Comment comment = new Comment(content);
        switch (FileProcessor.resolveCommentType(comment, extraLine, extra2Line)) {
            case CLASS: {
                this.processClass(comment);
                break;
            }
            case CFG: {
                this.processCfg(comment);
                break;
            }
            case PROPERTY: {
                this.processProperty(comment, extraLine);
                break;
            }
            case METHOD: {
                this.processMethod(comment, extraLine);
                break;
            }
            case EVENT: {
                this.processEvent(comment);
            }
        }
    }

    private boolean isWhite(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '.' && ch != '_';
    }

    private void processFile(String fileName) {
        try {
            int numRead;
            File file = new File(new File(fileName).getAbsolutePath());
            this.context.setCurrentFile(file);
            this.context.position = 0L;
            this.logger.fine(MessageFormat.format("Processing: {0}", this.context.getCurrentFile().fileName));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
            State state = State.CODE;
            ExtraState extraState = ExtraState.SKIP;
            StringBuilder buffer = new StringBuilder();
            StringBuilder extraBuffer = new StringBuilder();
            StringBuilder extra2Buffer = new StringBuilder();
            String comment = null;
            while ((numRead = reader.read()) != -1) {
                ++this.context.position;
                char ch = (char)numRead;
                buffer.append(ch);
                switch (state) {
                    case CODE: {
                        switch (extraState) {
                            case SKIP: {
                                break;
                            }
                            case SPACE: {
                                if (this.isWhite(ch)) break;
                                extraState = ExtraState.READ;
                            }
                            case READ: {
                                if (this.isWhite(ch)) {
                                    extraState = ExtraState.SPACE2;
                                    break;
                                }
                                extraBuffer.append(ch);
                                break;
                            }
                            case SPACE2: {
                                if (this.isWhite(ch)) break;
                                extraState = ExtraState.READ2;
                            }
                            case READ2: {
                                if (this.isWhite(ch)) {
                                    extraState = ExtraState.SKIP;
                                    break;
                                }
                                extra2Buffer.append(ch);
                            }
                        }
                        if (!StringUtils.endsWith(buffer, START_COMMENT)) break;
                        if (comment != null) {
                            this.processComment(comment, extraBuffer.toString(), extra2Buffer.toString());
                        }
                        this.context.lastCommentPosition = this.context.position - 2L;
                        extraBuffer.setLength(0);
                        extra2Buffer.setLength(0);
                        buffer.setLength(0);
                        state = State.COMMENT;
                        break;
                    }
                    case COMMENT: {
                        if (!StringUtils.endsWith(buffer, END_COMMENT)) break;
                        comment = buffer.substring(0, buffer.length() - END_COMMENT.length());
                        buffer.setLength(0);
                        state = State.CODE;
                        extraState = ExtraState.SPACE;
                    }
                }
            }
            this.processComment(comment, extraBuffer.toString(), extra2Buffer.toString());
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createClassHierarchy() {
        for (DocClass docClass : this.context.getClasses()) {
            for (DocClass cls : this.context.getClasses()) {
                if (!docClass.className.equals(cls.parentClass)) continue;
                ClassDescr subClass = new ClassDescr();
                subClass.className = cls.className;
                subClass.shortClassName = cls.shortClassName;
                docClass.subClasses.add(subClass);
                cls.parent = docClass;
            }
            for (DocCfg cfg : this.context.getCfgs()) {
                if (!docClass.className.equals(cfg.className)) continue;
                docClass.cfgs.add(cfg);
            }
            for (DocProperty property : this.context.getProperties()) {
                if (!docClass.className.equals(property.className)) continue;
                docClass.properties.add(property);
            }
            for (DocMethod method : this.context.getMethods()) {
                if (!docClass.className.equals(method.className)) continue;
                docClass.methods.add(method);
            }
            for (DocEvent event : this.context.getEvents()) {
                if (!docClass.className.equals(event.className)) continue;
                docClass.events.add(event);
            }
        }
    }

    private <T extends DocAttribute> boolean isOverridden(T doc, List<T> docs) {
        if (doc.name == null || doc.name.isEmpty()) {
            return false;
        }
        for (DocAttribute attr : docs) {
            String attrName;
            String docName = StringUtils.separateByLastDot(doc.name)[1];
            if (!docName.equals(attrName = StringUtils.separateByLastDot(attr.name)[1])) continue;
            return true;
        }
        return false;
    }

    private <T extends Doc> void removeHidden(List<T> docs) {
        ListIterator<T> it = docs.listIterator();
        while (it.hasNext()) {
            if (!((Doc)it.next()).hide) continue;
            it.remove();
        }
    }

    private <T extends DocAttribute> void addInherited(List<T> childDocs, List<T> parentDocs) {
        for (DocAttribute attr : parentDocs) {
            if (this.isOverridden(attr, childDocs) || attr.isStatic) continue;
            childDocs.add(attr);
        }
    }

    private void injectInherited() {
        for (DocClass cls : this.context.getClasses()) {
            DocClass parent = cls.parent;
            while (parent != null) {
                ClassDescr superClass = new ClassDescr();
                superClass.className = parent.className;
                superClass.shortClassName = parent.shortClassName;
                cls.superClasses.add(superClass);
                if (parent.className.equals(COMPONENT_NAME)) {
                    cls.component = true;
                }
                this.addInherited(cls.cfgs, parent.cfgs);
                this.addInherited(cls.properties, parent.properties);
                this.addInherited(cls.methods, parent.methods);
                this.addInherited(cls.events, parent.events);
                parent = parent.parent;
            }
            this.removeHidden(cls.cfgs);
            this.removeHidden(cls.properties);
            this.removeHidden(cls.methods);
            this.removeHidden(cls.events);
            Collections.sort(cls.cfgs);
            Collections.sort(cls.properties);
            Collections.sort(cls.methods);
            Collections.sort(cls.events);
            Collections.reverse(cls.superClasses);
            Collections.sort(cls.subClasses);
        }
        this.removeHidden(this.context.getClasses());
    }

    private void createPackageHierarchy() {
        for (DocClass cls : this.context.getClasses()) {
            this.context.addClassToTree(cls);
        }
        this.context.sortTree();
    }

    private void showStatistics() {
        this.logger.fine("*** STATISTICS ***");
        for (Map.Entry<String, Integer> e : Comment.allTags.entrySet()) {
            this.logger.fine(e.getKey() + ": " + e.getValue());
        }
    }

    private void processDir(String dirName) {
        File file = new File(dirName);
        if (file.exists()) {
            if (!this.skipHidden || !file.isHidden()) {
                if (file.isDirectory()) {
                    String[] children;
                    for (String child : children = file.list()) {
                        this.processDir(dirName + File.separator + child);
                    }
                } else if (this.filePattern.matcher(file.getName()).matches()) {
                    this.processFile(dirName);
                }
            }
        } else {
            this.logger.warning(MessageFormat.format("File {0} not found", dirName));
        }
    }

    public void process(String fileName, String[] extraSrc) {
        try {
            if (fileName != null) {
                List<Source> sources;
                Sources srcs;
                File xmlFile = new File(new File(fileName).getAbsolutePath());
                FileInputStream fileInputStream = new FileInputStream(xmlFile);
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"extdoc.jsdoc.schema");
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                extdoc.jsdoc.schema.Doc doc = (extdoc.jsdoc.schema.Doc)unmarshaller.unmarshal((InputStream)fileInputStream);
                Tags tags = doc.getTags();
                if (tags != null) {
                    this.context.setCustomTags(doc.getTags().getTag());
                }
                if ((srcs = doc.getSources()) != null && (sources = srcs.getSource()) != null) {
                    for (Source src : sources) {
                        String m = src.getMatch();
                        Boolean sh = src.isSkipHidden();
                        this.skipHidden = sh != null ? sh : true;
                        this.filePattern = Pattern.compile(StringUtils.wildcardToRegex(m != null ? m : DEFAULT_MATCH));
                        this.processDir(xmlFile.getParent() + File.separator + src.getSrc());
                    }
                }
                fileInputStream.close();
            }
            if (extraSrc != null) {
                for (String src : extraSrc) {
                    this.processDir(src);
                }
            }
            this.showStatistics();
            this.createClassHierarchy();
            this.injectInherited();
            this.createPackageHierarchy();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isHidden()) {
            return;
        }
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            for (String child : children = sourceLocation.list()) {
                this.copyDirectory(new File(sourceLocation, child), new File(targetLocation, child));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void readWrapper(String wrapper, StringBuilder prefix, StringBuilder suffix) {
        try {
            int numRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wrapper), ENCODING));
            while ((numRead = reader.read()) != -1 && !StringUtils.endsWith(prefix, WRAPPER_CODE_MARKER)) {
                prefix.append((char)numRead);
            }
            int len = prefix.length();
            prefix.delete(len - WRAPPER_CODE_MARKER.length(), len);
            suffix.append((char)numRead);
            while ((numRead = reader.read()) != -1) {
                suffix.append((char)numRead);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copySourceFiles(String targetDir, String wrapper) {
        new File(targetDir).mkdirs();
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        this.readWrapper(wrapper, prefix, suffix);
        for (DocFile docFile : this.context.getDocFiles()) {
            try {
                int numRead;
                File dst = new File(targetDir + File.separator + docFile.targetFileName);
                StringBuilder buffer = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(docFile.file), ENCODING));
                int position = 0;
                ListIterator<Doc> it = docFile.docs.listIterator();
                Doc doc = it.hasNext() ? it.next() : null;
                buffer.append((CharSequence)prefix);
                while ((numRead = reader.read()) != -1) {
                    char ch = (char)numRead;
                    if (doc != null && (long)(++position) == doc.positionInFile) {
                        buffer.append(MessageFormat.format("<div id=\"{0}\"></div>", doc.id));
                        doc = it.hasNext() ? it.next() : null;
                    }
                    buffer.append(ch);
                }
                buffer.append((CharSequence)suffix);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), ENCODING));
                out.write(buffer.toString());
                ((Writer)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveToFolder(String folderName, String templateFileName) {
        new File(folderName).mkdirs();
        try {
            File templateFile = new File(new File(templateFileName).getAbsolutePath());
            String templateFolder = templateFile.getParent();
            JAXBContext jaxbTplContext = JAXBContext.newInstance((String)"extdoc.jsdoc.tplschema");
            Unmarshaller unmarshaller = jaxbTplContext.createUnmarshaller();
            Template template = (Template)unmarshaller.unmarshal((InputStream)new FileInputStream(templateFile));
            ClassTemplate classTemplate = template.getClassTemplate();
            String classTplFileName = templateFolder + File.separator + classTemplate.getTpl();
            String classTplTargetDir = folderName + File.separator + classTemplate.getTargetDir();
            TreeTemplate treeTemplate = template.getTreeTemplate();
            String treeTplFileName = templateFolder + File.separator + treeTemplate.getTpl();
            String treeTplTargetFile = folderName + File.separator + treeTemplate.getTargetFile();
            this.logger.info("*** COPY RESOURCES ***");
            new File(classTplTargetDir).mkdirs();
            Resources resources = template.getResources();
            List<Copy> dirs = resources.getCopy();
            for (Copy dir : dirs) {
                String src = templateFolder + File.separator + dir.getSrc();
                String dst = folderName + File.separator + dir.getDst();
                this.copyDirectory(new File(src), new File(dst));
            }
            this.logger.info("*** COPY SOURCE FILES ***");
            String sourceTargetDir = folderName + File.separator + template.getSource().getTargetDir();
            this.logger.info(MessageFormat.format("Target folder: {0}", sourceTargetDir));
            String wrapperFile = templateFolder + File.separator + template.getSource().getWrapper();
            this.copySourceFiles(sourceTargetDir, wrapperFile);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"extdoc.jsdoc.docs");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates transformation = factory.newTemplates(new StreamSource(classTplFileName));
            Transformer transformer = transformation.newTransformer();
            DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
            this.logger.info("*** SAVING FILES ***");
            for (DocClass docClass : this.context.getClasses()) {
                this.logger.fine("Saving: " + docClass.className);
                String targetFileName = classTplTargetDir + File.separator + docClass.className + '.' + OUT_FILE_EXTENSION;
                Document doc = docBuilder.newDocument();
                marshaller.marshal((Object)docClass, (Node)doc);
                StreamResult fileResult = new StreamResult(new File(targetFileName));
                transformer.transform(new DOMSource(doc), fileResult);
                transformer.reset();
            }
            JAXBContext jaxbTreeContext = JAXBContext.newInstance((String)"extdoc.jsdoc.tree");
            Marshaller treeMarshaller = jaxbTreeContext.createMarshaller();
            treeMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            Templates treeTransformation = factory.newTemplates(new StreamSource(treeTplFileName));
            Transformer treeTransformer = treeTransformation.newTransformer();
            Document doc = builderFactory.newDocumentBuilder().newDocument();
            treeMarshaller.marshal((Object)this.context.getTree(), (Node)doc);
            StreamResult fileResult = new StreamResult(new File(treeTplTargetFile));
            treeTransformer.transform(new DOMSource(doc), fileResult);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum ExtraState {
        SKIP,
        SPACE,
        READ,
        SPACE2,
        READ2;

    }

    private static enum State {
        CODE,
        COMMENT;

    }

    static enum CommentType {
        CLASS,
        CFG,
        PROPERTY,
        METHOD,
        EVENT;

    }

    private static enum LinkStates {
        READ,
        LINK;

    }
}

