/*
 * Decompiled with CFR 0.152.
 */
package extdoc.jsdoc.tags.impl;

import extdoc.jsdoc.tags.Tag;
import extdoc.jsdoc.tags.impl.CfgTagImpl;
import extdoc.jsdoc.tags.impl.ClassTagImpl;
import extdoc.jsdoc.tags.impl.EventTagImpl;
import extdoc.jsdoc.tags.impl.ExtendsTagImpl;
import extdoc.jsdoc.tags.impl.MemberTagImpl;
import extdoc.jsdoc.tags.impl.ParamTagImpl;
import extdoc.jsdoc.tags.impl.PropertyTagImpl;
import extdoc.jsdoc.tags.impl.ReturnTagImpl;
import extdoc.jsdoc.tags.impl.TagImpl;
import extdoc.jsdoc.tags.impl.TypeTagImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Comment {
    public static Map<String, Integer> allTags = new HashMap<String, Integer>();
    private final List<Tag> tagList = new ArrayList<Tag>();
    private String description;

    public String getDescription() {
        return this.description;
    }

    public <T extends Tag> T tag(String tagName) {
        for (Tag tag : this.tagList) {
            if (!tag.name().equals(tagName)) continue;
            return (T)tag;
        }
        return null;
    }

    public <T extends Tag> List<T> tags(String tagName) {
        ArrayList<Tag> found = new ArrayList<Tag>();
        for (Tag tag : this.tagList) {
            if (!tag.name().equals(tagName)) continue;
            found.add(tag);
        }
        return found;
    }

    public boolean hasTag(String tagName) {
        for (Tag tag : this.tagList) {
            if (!tag.name().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public Comment(final String content) {
        class CommentStringParser {
            CommentStringParser() {
            }

            private boolean isStarWhite(char ch) {
                return Character.isWhitespace(ch) || ch == '*';
            }

            private String removeStars() {
                CommentState state = CommentState.SPACE;
                StringBuilder buffer = new StringBuilder();
                StringBuilder spaceBuffer = new StringBuilder();
                boolean foundStar = false;
                block4: for (int i = 0; i < content.length(); ++i) {
                    char ch = content.charAt(i);
                    switch (state) {
                        case SPACE: {
                            if (this.isStarWhite(ch)) {
                                if (ch == '*') {
                                    foundStar = true;
                                }
                                spaceBuffer.append(ch);
                                continue block4;
                            }
                            if (!foundStar) {
                                buffer.append((CharSequence)spaceBuffer);
                            }
                            spaceBuffer.setLength(0);
                            state = CommentState.DESCRIPTION;
                        }
                        case DESCRIPTION: {
                            if (ch == '\n') {
                                foundStar = false;
                                state = CommentState.SPACE;
                            }
                            buffer.append(ch);
                        }
                    }
                }
                return buffer.toString();
            }

            void parseCommentStateMachine() {
                String inner = this.removeStars();
                InnerState instate = InnerState.TAG_GAP;
                String tagName = null;
                int tagStart = 0;
                int textStart = 0;
                boolean validTag = true;
                int lastNonWhite = -1;
                int len = inner.length();
                for (int i = 0; i < len; ++i) {
                    char ch = inner.charAt(i);
                    boolean isWhite = Character.isWhitespace(ch);
                    switch (instate) {
                        case TAG_NAME: {
                            if (!isWhite) break;
                            tagName = inner.substring(tagStart, i);
                            instate = InnerState.TAG_GAP;
                            break;
                        }
                        case TAG_GAP: {
                            if (isWhite) break;
                            textStart = i;
                            instate = InnerState.IN_TEXT;
                        }
                        case IN_TEXT: {
                            if (!validTag || ch != '@') break;
                            this.parseCommentComponent(inner, tagName, textStart, lastNonWhite + 1);
                            tagStart = i;
                            instate = InnerState.TAG_NAME;
                        }
                    }
                    validTag = isWhite;
                    if (isWhite) continue;
                    lastNonWhite = i;
                }
                switch (instate) {
                    case TAG_NAME: {
                        tagName = inner.substring(tagStart, len);
                    }
                    case TAG_GAP: {
                        textStart = len;
                    }
                    case IN_TEXT: {
                        this.parseCommentComponent(inner, tagName, textStart, lastNonWhite + 1);
                    }
                }
            }

            private void parseCommentComponent(String content2, String tagName, int from, int upto) {
                String tx;
                String string = tx = upto <= from ? "" : content2.substring(from, upto);
                if (tagName == null) {
                    Comment.this.description = tx;
                } else {
                    TagImpl tag = tagName.equals("@class") ? new ClassTagImpl(tagName, tx) : (tagName.equals("@param") ? new ParamTagImpl(tagName, tx) : (tagName.equals("@extends") ? new ExtendsTagImpl(tagName, tx) : (tagName.equals("@cfg") ? new CfgTagImpl(tagName, tx) : (tagName.equals("@type") ? new TypeTagImpl(tagName, tx) : (tagName.equals("@return") ? new ReturnTagImpl(tagName, tx) : (tagName.equals("@member") ? new MemberTagImpl(tagName, tx) : (tagName.equals("@event") ? new EventTagImpl(tagName, tx) : (tagName.equals("@property") ? new PropertyTagImpl(tagName, tx) : new TagImpl(tagName, tx)))))))));
                    Integer num = allTags.get(tagName);
                    allTags.put(tagName, num == null ? 1 : num + 1);
                    Comment.this.tagList.add(tag);
                }
            }
        }
        new CommentStringParser().parseCommentStateMachine();
    }

    private static enum InnerState {
        TAG_NAME,
        TAG_GAP,
        IN_TEXT;

    }

    private static enum CommentState {
        SPACE,
        DESCRIPTION;

    }
}

