/*
 * Decompiled with CFR 0.152.
 */
package extdoc.jsdoc.tree;

import extdoc.jsdoc.docs.DocClass;
import extdoc.jsdoc.tree.TreeClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TreePackage
implements Comparable<TreePackage> {
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String fullName;
    public List<TreePackage> packages = new ArrayList<TreePackage>();
    public List<TreeClass> classes = new ArrayList<TreeClass>();

    public void addClass(DocClass docClass) {
        this.addClass(docClass.packageName, docClass);
    }

    public void addClass(String packageName, DocClass docClass) {
        if (packageName.equals("")) {
            TreeClass treeClass = new TreeClass();
            treeClass.className = docClass.className;
            treeClass.shortClassName = docClass.shortClassName;
            treeClass.singleton = docClass.singleton;
            treeClass.component = docClass.component;
            treeClass.customTags = docClass.customTags;
            this.classes.add(treeClass);
        } else {
            int i;
            int len = packageName.length();
            for (i = 0; i < len && packageName.charAt(i) != '.'; ++i) {
            }
            String pkg = packageName.substring(0, i);
            String remains = i < len ? packageName.substring(i + 1, len) : "";
            TreePackage p = this.addPackage(pkg);
            p.addClass(remains, docClass);
        }
    }

    protected TreePackage addPackage(String packageName) {
        for (TreePackage p : this.packages) {
            if (!p.name.equals(packageName)) continue;
            return p;
        }
        TreePackage p = new TreePackage();
        p.name = packageName;
        p.fullName = this.fullName != null ? this.fullName + '.' + packageName : packageName;
        this.packages.add(p);
        return p;
    }

    public void sort() {
        for (TreePackage p : this.packages) {
            p.sort();
        }
        Collections.sort(this.packages);
        Collections.sort(this.classes);
    }

    @Override
    public int compareTo(TreePackage o) {
        return this.name.compareTo(o.name);
    }
}

